extends PhysicsBody3D
class_name PhysicalBone3D

## A physics body used to make bones in a [Skeleton3D] react to physics.
##
## The [PhysicalBone3D] node is a physics body that can be used to make bones in a [Skeleton3D] react to physics.
## [b]Note:[/b] In order to detect physical bones with raycasts, the [member SkeletonModifier3D.active] property of the parent [PhysicalBoneSimulator3D] must be [code]true[/code] and the [Skeleton3D]'s bone must be assigned to [PhysicalBone3D] correctly; it means that [method get_bone_id] should return a valid id ([code]>= 0[/code]).


## In this mode, the body's damping value is added to any value set in areas or the default value.
## In this mode, the body's damping value replaces any value set in areas or the default value.

#enum DampMode
enum {
    DAMP_MODE_COMBINE = 0,
    DAMP_MODE_REPLACE = 1,
}
#enum JointType
enum {
    JOINT_TYPE_NONE = 0,
    JOINT_TYPE_PIN = 1,
    JOINT_TYPE_CONE = 2,
    JOINT_TYPE_HINGE = 3,
    JOINT_TYPE_SLIDER = 4,
    JOINT_TYPE_6DOF = 5,
}
## Damps the body's rotation. By default, the body will use the [b]Default Angular Damp[/b] in [b]Project > Project Settings > Physics > 3d[/b] or any value override set by an [Area3D] the body is in. Depending on [member angular_damp_mode], you can set [member angular_damp] to be added to or to replace the body's damping value.
## See [member ProjectSettings.physics/3d/default_angular_damp] for more details about damping.
var angular_damp: float:
	get = get_angular_damp, set = set_angular_damp

## Defines how [member angular_damp] is applied. See [enum DampMode] for possible values.
var angular_damp_mode: int:
	get = get_angular_damp_mode, set = set_angular_damp_mode

## The PhysicalBone3D's rotational velocity in [i]radians[/i] per second.
var angular_velocity: Vector3:
	get = get_angular_velocity, set = set_angular_velocity

## Sets the body's transform.
var body_offset: Transform3D:
	get = get_body_offset, set = set_body_offset

## The body's bounciness. Values range from [code]0[/code] (no bounce) to [code]1[/code] (full bounciness).
## [b]Note:[/b] Even with [member bounce] set to [code]1.0[/code], some energy will be lost over time due to linear and angular damping. To have a [PhysicalBone3D] that preserves all its energy over time, set [member bounce] to [code]1.0[/code], [member linear_damp_mode] to [constant DAMP_MODE_REPLACE], [member linear_damp] to [code]0.0[/code], [member angular_damp_mode] to [constant DAMP_MODE_REPLACE], and [member angular_damp] to [code]0.0[/code].
var bounce: float:
	get = get_bounce, set = set_bounce

## If [code]true[/code], the body is deactivated when there is no movement, so it will not take part in the simulation until it is awakened by an external force.
var can_sleep: bool:
	get = is_able_to_sleep, set = set_can_sleep

## If [code]true[/code], the standard force integration (like gravity or damping) will be disabled for this body. Other than collision response, the body will only move as determined by the [method _integrate_forces] method, if that virtual method is overridden.
## Setting this property will call the method [method PhysicsServer3D.body_set_omit_force_integration] internally.
var custom_integrator: bool:
	get = is_using_custom_integrator, set = set_use_custom_integrator

## The body's friction, from [code]0[/code] (frictionless) to [code]1[/code] (max friction).
var friction: float:
	get = get_friction, set = set_friction

## This is multiplied by the global 3D gravity setting found in [b]Project > Project Settings > Physics > 3d[/b] to produce the body's gravity. For example, a value of 1 will be normal gravity, 2 will apply double gravity, and 0.5 will apply half gravity to this object.
var gravity_scale: float:
	get = get_gravity_scale, set = set_gravity_scale

## Sets the joint's transform.
var joint_offset: Transform3D:
	get = get_joint_offset, set = set_joint_offset

## Sets the joint's rotation in radians.
var joint_rotation: Vector3:
	get = get_joint_rotation, set = set_joint_rotation

## Sets the joint type. See [enum JointType] for possible values.
var joint_type: int:
	get = get_joint_type, set = set_joint_type

## Damps the body's movement. By default, the body will use the [b]Default Linear Damp[/b] in [b]Project > Project Settings > Physics > 3d[/b] or any value override set by an [Area3D] the body is in. Depending on [member linear_damp_mode], you can set [member linear_damp] to be added to or to replace the body's damping value.
## See [member ProjectSettings.physics/3d/default_linear_damp] for more details about damping.
var linear_damp: float:
	get = get_linear_damp, set = set_linear_damp

## Defines how [member linear_damp] is applied. See [enum DampMode] for possible values.
var linear_damp_mode: int:
	get = get_linear_damp_mode, set = set_linear_damp_mode

## The body's linear velocity in units per second. Can be used sporadically, but [b]don't set this every frame[/b], because physics may run in another thread and runs at a different granularity. Use [method _integrate_forces] as your process loop for precise control of the body state.
var linear_velocity: Vector3:
	get = get_linear_velocity, set = set_linear_velocity

## The body's mass.
var mass: float:
	get = get_mass, set = set_mass



## Called during physics processing, allowing you to read and safely modify the simulation state for the object. By default, it is called before the standard force integration, but the [member custom_integrator] property allows you to disable the standard force integration and do fully custom force integration for a body.
func _integrate_forces(state: PhysicsDirectBodyState3D) -> void:
	pass;

func apply_central_impulse(impulse: Vector3) -> void:
	pass;

func apply_impulse(impulse: Vector3, position: Vector3 = Vector3(0, 0, 0)) -> void:
	pass;

func get_bone_id() -> int:
	pass;

func get_simulate_physics() -> bool:
	pass;

func is_simulating_physics() -> bool:
	pass;


func get_angular_damp() -> float:
	return angular_damp

func set_angular_damp(value: float) -> void:
	angular_damp = value

func get_angular_damp_mode() -> int:
	return angular_damp_mode

func set_angular_damp_mode(value: int) -> void:
	angular_damp_mode = value

func get_angular_velocity() -> Vector3:
	return angular_velocity

func set_angular_velocity(value: Vector3) -> void:
	angular_velocity = value

func get_body_offset() -> Transform3D:
	return body_offset

func set_body_offset(value: Transform3D) -> void:
	body_offset = value

func get_bounce() -> float:
	return bounce

func set_bounce(value: float) -> void:
	bounce = value

func is_able_to_sleep() -> bool:
	return can_sleep

func set_can_sleep(value: bool) -> void:
	can_sleep = value

func is_using_custom_integrator() -> bool:
	return custom_integrator

func set_use_custom_integrator(value: bool) -> void:
	custom_integrator = value

func get_friction() -> float:
	return friction

func set_friction(value: float) -> void:
	friction = value

func get_gravity_scale() -> float:
	return gravity_scale

func set_gravity_scale(value: float) -> void:
	gravity_scale = value

func get_joint_offset() -> Transform3D:
	return joint_offset

func set_joint_offset(value: Transform3D) -> void:
	joint_offset = value

func get_joint_rotation() -> Vector3:
	return joint_rotation

func set_joint_rotation(value: Vector3) -> void:
	joint_rotation = value

func get_joint_type() -> int:
	return joint_type

func set_joint_type(value: int) -> void:
	joint_type = value

func get_linear_damp() -> float:
	return linear_damp

func set_linear_damp(value: float) -> void:
	linear_damp = value

func get_linear_damp_mode() -> int:
	return linear_damp_mode

func set_linear_damp_mode(value: int) -> void:
	linear_damp_mode = value

func get_linear_velocity() -> Vector3:
	return linear_velocity

func set_linear_velocity(value: Vector3) -> void:
	linear_velocity = value

func get_mass() -> float:
	return mass

func set_mass(value: float) -> void:
	mass = value

