extends Node3D
class_name OpenXRHand

## Node supporting hand and finger tracking in OpenXR.
##
## This node enables OpenXR's hand tracking functionality. The node should be a child node of an [XROrigin3D] node, tracking will update its position to the player's tracked hand Palm joint location (the center of the middle finger's metacarpal bone). This node also updates the skeleton of a properly skinned hand or avatar model.
## If the skeleton is a hand (one of the hand bones is the root node of the skeleton), then the skeleton will be placed relative to the hand palm location and the hand mesh and skeleton should be children of the OpenXRHand node.
## If the hand bones are part of a full skeleton, then the root of the hand will keep its location with the assumption that IK is used to position the hand and arm.
## By default the skeleton hand bones are repositioned to match the size of the tracked hand. To preserve the modeled bone sizes change [member bone_update] to apply rotation only.


## Tracking the player's left hand.
## Tracking the player's right hand.
## Maximum supported hands.
## When player grips, hand skeleton will form a full fist.
## When player grips, hand skeleton conforms to the controller the player is holding.
## Maximum supported motion ranges.
## An OpenXR compliant skeleton.
## A [SkeletonProfileHumanoid] compliant skeleton.
## Maximum supported hands.
## The skeletons bones are fully updated (both position and rotation) to match the tracked bones.
## The skeletons bones are only rotated to align with the tracked bones, preserving bone length.
## Maximum supported bone update mode.

#enum Hands
enum {
    HAND_LEFT = 0,
    HAND_RIGHT = 1,
    HAND_MAX = 2,
}
#enum MotionRange
enum {
    MOTION_RANGE_UNOBSTRUCTED = 0,
    MOTION_RANGE_CONFORM_TO_CONTROLLER = 1,
    MOTION_RANGE_MAX = 2,
}
#enum SkeletonRig
enum {
    SKELETON_RIG_OPENXR = 0,
    SKELETON_RIG_HUMANOID = 1,
    SKELETON_RIG_MAX = 2,
}
#enum BoneUpdate
enum {
    BONE_UPDATE_FULL = 0,
    BONE_UPDATE_ROTATION_ONLY = 1,
    BONE_UPDATE_MAX = 2,
}
## Specify the type of updates to perform on the bone.
var bone_update: int:
	get = get_bone_update, set = set_bone_update

## Specifies whether this node tracks the left or right hand of the player.
var hand: int:
	get = get_hand, set = set_hand

## Set a [Skeleton3D] node for which the pose positions will be updated.
var hand_skeleton: NodePath:
	get = get_hand_skeleton, set = set_hand_skeleton

## Set the motion range (if supported) limiting the hand motion.
var motion_range: int:
	get = get_motion_range, set = set_motion_range

## Set the type of skeleton rig the [member hand_skeleton] is compliant with.
var skeleton_rig: int:
	get = get_skeleton_rig, set = set_skeleton_rig




func get_bone_update() -> int:
	return bone_update

func set_bone_update(value: int) -> void:
	bone_update = value

func get_hand() -> int:
	return hand

func set_hand(value: int) -> void:
	hand = value

func get_hand_skeleton() -> NodePath:
	return hand_skeleton

func set_hand_skeleton(value: NodePath) -> void:
	hand_skeleton = value

func get_motion_range() -> int:
	return motion_range

func set_motion_range(value: int) -> void:
	motion_range = value

func get_skeleton_rig() -> int:
	return skeleton_rig

func set_skeleton_rig(value: int) -> void:
	skeleton_rig = value

