extends Node3D
class_name OpenXRCompositionLayer

## The parent class of all OpenXR composition layer nodes.
##
## Composition layers allow 2D viewports to be displayed inside of the headset by the XR compositor through special projections that retain their quality. This allows for rendering clear text while keeping the layer at a native resolution.
## [b]Note:[/b] If the OpenXR runtime doesn't support the given composition layer type, a fallback mesh can be generated with a [ViewportTexture], in order to emulate the composition layer.



## Enables the blending the layer using its alpha channel.
## Can be combined with [member Viewport.transparent_bg] to give the layer a transparent background.
var alpha_blend: bool:
	get = get_alpha_blend, set = set_alpha_blend

## Enables a technique called "hole punching", which allows putting the composition layer behind the main projection layer (i.e. setting [member sort_order] to a negative value) while "punching a hole" through everything rendered by Godot so that the layer is still visible.
## This can be used to create the illusion that the composition layer exists in the same 3D space as everything rendered by Godot, allowing objects to appear to pass both behind or in front of the composition layer.
var enable_hole_punch: bool:
	get = get_enable_hole_punch, set = set_enable_hole_punch

## The [SubViewport] to render on the composition layer.
var layer_viewport: SubViewport:
	get = get_layer_viewport, set = set_layer_viewport

## The sort order for this composition layer. Higher numbers will be shown in front of lower numbers.
## [b]Note:[/b] This will have no effect if a fallback mesh is being used.
var sort_order: int:
	get = get_sort_order, set = set_sort_order



## Returns UV coordinates where the given ray intersects with the composition layer. [param origin] and [param direction] must be in global space.
## Returns [code]Vector2(-1.0, -1.0)[/code] if the ray doesn't intersect.
func intersects_ray(origin: Vector3, direction: Vector3) -> Vector2:
	pass;

## Returns true if the OpenXR runtime natively supports this composition layer type.
## [b]Note:[/b] This will only return an accurate result after the OpenXR session has started.
func is_natively_supported() -> bool:
	pass;


func get_alpha_blend() -> bool:
	return alpha_blend

func set_alpha_blend(value: bool) -> void:
	alpha_blend = value

func get_enable_hole_punch() -> bool:
	return enable_hole_punch

func set_enable_hole_punch(value: bool) -> void:
	enable_hole_punch = value

func get_layer_viewport() -> SubViewport:
	return layer_viewport

func set_layer_viewport(value: SubViewport) -> void:
	layer_viewport = value

func get_sort_order() -> int:
	return sort_order

func set_sort_order(value: int) -> void:
	sort_order = value

