extends Resource
class_name NavigationMeshSourceGeometryData2D

## Container for parsed source geometry data used in navigation mesh baking.
##
## Container for parsed source geometry data used in navigation mesh baking.





## Adds the outline points of a shape as obstructed area.
func add_obstruction_outline(shape_outline: PackedVector2Array) -> void:
	pass;

## Adds a projected obstruction shape to the source geometry. If [param carve] is [code]true[/code] the carved shape will not be affected by additional offsets (e.g. agent radius) of the navigation mesh baking process.
func add_projected_obstruction(vertices: PackedVector2Array, carve: bool) -> void:
	pass;

## Adds the outline points of a shape as traversable area.
func add_traversable_outline(shape_outline: PackedVector2Array) -> void:
	pass;

## Appends another array of [param obstruction_outlines] at the end of the existing obstruction outlines array.
func append_obstruction_outlines(obstruction_outlines: Array[PackedVector2Array]) -> void:
	pass;

## Appends another array of [param traversable_outlines] at the end of the existing traversable outlines array.
func append_traversable_outlines(traversable_outlines: Array[PackedVector2Array]) -> void:
	pass;

## Clears the internal data.
func clear() -> void:
	pass;

## Clears all projected obstructions.
func clear_projected_obstructions() -> void:
	pass;

## Returns all the obstructed area outlines arrays.
func get_obstruction_outlines() -> Array[PackedVector2Array]:
	pass;

## Returns the projected obstructions as an [Array] of dictionaries. Each [Dictionary] contains the following entries:
## - [code]vertices[/code] - A [PackedFloat32Array] that defines the outline points of the projected shape.
## - [code]carve[/code] - A [bool] that defines how the projected shape affects the navigation mesh baking. If [code]true[/code] the projected shape will not be affected by addition offsets, e.g. agent radius.
func get_projected_obstructions() -> Array:
	pass;

## Returns all the traversable area outlines arrays.
func get_traversable_outlines() -> Array[PackedVector2Array]:
	pass;

## Returns [code]true[/code] when parsed source geometry data exists.
func has_data() -> bool:
	pass;

## Adds the geometry data of another [NavigationMeshSourceGeometryData2D] to the navigation mesh baking data.
func merge(other_geometry: NavigationMeshSourceGeometryData2D) -> void:
	pass;

## Sets all the obstructed area outlines arrays.
func set_obstruction_outlines(obstruction_outlines: Array[PackedVector2Array]) -> void:
	pass;

## Sets the projected obstructions with an Array of Dictionaries with the following key value pairs:
## [codeblocks]
## [gdscript]
## "vertices" : PackedFloat32Array
## "carve" : bool
## [/gdscript]
## [/codeblocks]
func set_projected_obstructions(projected_obstructions: Array) -> void:
	pass;

## Sets all the traversable area outlines arrays.
func set_traversable_outlines(traversable_outlines: Array[PackedVector2Array]) -> void:
	pass;


