extends Node
class_name MissingNode

## An internal editor class intended for keeping the data of unrecognized nodes.
##
## This is an internal editor class intended for keeping data of nodes of unknown type (most likely this type was supplied by an extension that is no longer loaded). It can't be manually instantiated or placed in a scene.
## [b]Warning:[/b] Ignore missing nodes unless you know what you are doing. Existing properties on a missing node can be freely modified in code, regardless of the type they are intended to be.



## The name of the class this node was supposed to be (see [method Object.get_class]).
var original_class: String:
	get = get_original_class, set = set_original_class

## Returns the path of the scene this node was instance of originally.
var original_scene: String:
	get = get_original_scene, set = set_original_scene

## If [code]true[/code], allows new properties to be set along with existing ones. If [code]false[/code], only existing properties' values can be set, and new properties cannot be added.
var recording_properties: bool:
	get = is_recording_properties, set = set_recording_properties




func get_original_class() -> String:
	return original_class

func set_original_class(value: String) -> void:
	original_class = value

func get_original_scene() -> String:
	return original_scene

func set_original_scene(value: String) -> void:
	original_scene = value

func is_recording_properties() -> bool:
	return recording_properties

func set_recording_properties(value: bool) -> void:
	recording_properties = value

