extends Resource
class_name MeshLibrary

## Library of meshes.
##
## A library of meshes. Contains a list of [Mesh] resources, each with a name and ID. Each item can also include collision and navigation shapes. This resource is used in [GridMap].
##
## @tutorial(3D Kinematic Character Demo): https://godotengine.org/asset-library/asset/2739
## @tutorial(3D Platformer Demo): https://godotengine.org/asset-library/asset/2748





## Clears the library.
func clear() -> void:
	pass;

## Creates a new item in the library with the given ID.
## You can get an unused ID from [method get_last_unused_item_id].
func create_item(id: int) -> void:
	pass;

## Returns the first item with the given name, or [code]-1[/code] if no item is found.
func find_item_by_name(name: String) -> int:
	pass;

## Returns the list of item IDs in use.
func get_item_list() -> PackedInt32Array:
	pass;

## Returns the item's mesh.
func get_item_mesh(id: int) -> Mesh:
	pass;

## Returns the transform applied to the item's mesh.
func get_item_mesh_transform(id: int) -> Transform3D:
	pass;

## Returns the item's name.
func get_item_name(id: int) -> String:
	pass;

## Returns the item's navigation layers bitmask.
func get_item_navigation_layers(id: int) -> int:
	pass;

## Returns the item's navigation mesh.
func get_item_navigation_mesh(id: int) -> NavigationMesh:
	pass;

## Returns the transform applied to the item's navigation mesh.
func get_item_navigation_mesh_transform(id: int) -> Transform3D:
	pass;

## When running in the editor, returns a generated item preview (a 3D rendering in isometric perspective). When used in a running project, returns the manually-defined item preview which can be set using [method set_item_preview]. Returns an empty [Texture2D] if no preview was manually set in a running project.
func get_item_preview(id: int) -> Texture2D:
	pass;

## Returns an item's collision shapes.
## The array consists of each [Shape3D] followed by its [Transform3D].
func get_item_shapes(id: int) -> Array:
	pass;

## Gets an unused ID for a new item.
func get_last_unused_item_id() -> int:
	pass;

## Removes the item.
func remove_item(id: int) -> void:
	pass;

## Sets the item's mesh.
func set_item_mesh(id: int, mesh: Mesh) -> void:
	pass;

## Sets the transform to apply to the item's mesh.
func set_item_mesh_transform(id: int, mesh_transform: Transform3D) -> void:
	pass;

## Sets the item's name.
## This name is shown in the editor. It can also be used to look up the item later using [method find_item_by_name].
func set_item_name(id: int, name: String) -> void:
	pass;

## Sets the item's navigation layers bitmask.
func set_item_navigation_layers(id: int, navigation_layers: int) -> void:
	pass;

## Sets the item's navigation mesh.
func set_item_navigation_mesh(id: int, navigation_mesh: NavigationMesh) -> void:
	pass;

## Sets the transform to apply to the item's navigation mesh.
func set_item_navigation_mesh_transform(id: int, navigation_mesh: Transform3D) -> void:
	pass;

## Sets a texture to use as the item's preview icon in the editor.
func set_item_preview(id: int, texture: Texture2D) -> void:
	pass;

## Sets an item's collision shapes.
## The array should consist of [Shape3D] objects, each followed by a [Transform3D] that will be applied to it. For shapes that should not have a transform, use [constant Transform3D.IDENTITY].
func set_item_shapes(id: int, shapes: Array) -> void:
	pass;


