extends RefCounted
class_name MeshConvexDecompositionSettings

## Parameters to be used with a [Mesh] convex decomposition operation.
##
## Parameters to be used with a [Mesh] convex decomposition operation.


## Constant for voxel-based approximate convex decomposition.
## Constant for tetrahedron-based approximate convex decomposition.

#enum Mode
enum {
    CONVEX_DECOMPOSITION_MODE_VOXEL = 0,
    CONVEX_DECOMPOSITION_MODE_TETRAHEDRON = 1,
}
## If [code]true[/code], uses approximation for computing convex hulls.
var convex_hull_approximation: bool:
	get = get_convex_hull_approximation, set = set_convex_hull_approximation

## Controls the precision of the convex-hull generation process during the clipping plane selection stage. Ranges from [code]1[/code] to [code]16[/code].
var convex_hull_downsampling: int:
	get = get_convex_hull_downsampling, set = set_convex_hull_downsampling

## Maximum concavity. Ranges from [code]0.0[/code] to [code]1.0[/code].
var max_concavity: float:
	get = get_max_concavity, set = set_max_concavity

## The maximum number of convex hulls to produce from the merge operation.
var max_convex_hulls: int:
	get = get_max_convex_hulls, set = set_max_convex_hulls

## Controls the maximum number of triangles per convex-hull. Ranges from [code]4[/code] to [code]1024[/code].
var max_num_vertices_per_convex_hull: int:
	get = get_max_num_vertices_per_convex_hull, set = set_max_num_vertices_per_convex_hull

## Controls the adaptive sampling of the generated convex-hulls. Ranges from [code]0.0[/code] to [code]0.01[/code].
var min_volume_per_convex_hull: float:
	get = get_min_volume_per_convex_hull, set = set_min_volume_per_convex_hull

## Mode for the approximate convex decomposition.
var mode: int:
	get = get_mode, set = set_mode

## If [code]true[/code], normalizes the mesh before applying the convex decomposition.
var normalize_mesh: bool:
	get = get_normalize_mesh, set = set_normalize_mesh

## Controls the granularity of the search for the "best" clipping plane. Ranges from [code]1[/code] to [code]16[/code].
var plane_downsampling: int:
	get = get_plane_downsampling, set = set_plane_downsampling

## If [code]true[/code], projects output convex hull vertices onto the original source mesh to increase floating-point accuracy of the results.
var project_hull_vertices: bool:
	get = get_project_hull_vertices, set = set_project_hull_vertices

## Maximum number of voxels generated during the voxelization stage.
var resolution: int:
	get = get_resolution, set = set_resolution

## Controls the bias toward clipping along revolution axes. Ranges from [code]0.0[/code] to [code]1.0[/code].
var revolution_axes_clipping_bias: float:
	get = get_revolution_axes_clipping_bias, set = set_revolution_axes_clipping_bias

## Controls the bias toward clipping along symmetry planes. Ranges from [code]0.0[/code] to [code]1.0[/code].
var symmetry_planes_clipping_bias: float:
	get = get_symmetry_planes_clipping_bias, set = set_symmetry_planes_clipping_bias




func get_convex_hull_approximation() -> bool:
	return convex_hull_approximation

func set_convex_hull_approximation(value: bool) -> void:
	convex_hull_approximation = value

func get_convex_hull_downsampling() -> int:
	return convex_hull_downsampling

func set_convex_hull_downsampling(value: int) -> void:
	convex_hull_downsampling = value

func get_max_concavity() -> float:
	return max_concavity

func set_max_concavity(value: float) -> void:
	max_concavity = value

func get_max_convex_hulls() -> int:
	return max_convex_hulls

func set_max_convex_hulls(value: int) -> void:
	max_convex_hulls = value

func get_max_num_vertices_per_convex_hull() -> int:
	return max_num_vertices_per_convex_hull

func set_max_num_vertices_per_convex_hull(value: int) -> void:
	max_num_vertices_per_convex_hull = value

func get_min_volume_per_convex_hull() -> float:
	return min_volume_per_convex_hull

func set_min_volume_per_convex_hull(value: float) -> void:
	min_volume_per_convex_hull = value

func get_mode() -> int:
	return mode

func set_mode(value: int) -> void:
	mode = value

func get_normalize_mesh() -> bool:
	return normalize_mesh

func set_normalize_mesh(value: bool) -> void:
	normalize_mesh = value

func get_plane_downsampling() -> int:
	return plane_downsampling

func set_plane_downsampling(value: int) -> void:
	plane_downsampling = value

func get_project_hull_vertices() -> bool:
	return project_hull_vertices

func set_project_hull_vertices(value: bool) -> void:
	project_hull_vertices = value

func get_resolution() -> int:
	return resolution

func set_resolution(value: int) -> void:
	resolution = value

func get_revolution_axes_clipping_bias() -> float:
	return revolution_axes_clipping_bias

func set_revolution_axes_clipping_bias(value: float) -> void:
	revolution_axes_clipping_bias = value

func get_symmetry_planes_clipping_bias() -> float:
	return symmetry_planes_clipping_bias

func set_symmetry_planes_clipping_bias(value: float) -> void:
	symmetry_planes_clipping_bias = value

