extends InputEventGesture
class_name InputEventPanGesture

## Represents a panning touch gesture.
##
## Stores information about pan gestures. A pan gesture is performed when the user swipes the touch screen with two fingers. It's typically used for panning/scrolling.
## [b]Note:[/b] On Android, this requires the [member ProjectSettings.input_devices/pointing/android/enable_pan_and_scale_gestures] project setting to be enabled.
##
## @tutorial(Using InputEvent): https://docs.godotengine.org/en/stable/tutorials/inputs/inputevent.html



## Panning amount since last pan event.
var delta: Vector2:
	get = get_delta, set = set_delta




func get_delta() -> Vector2:
	return delta

func set_delta(value: Vector2) -> void:
	delta = value

