extends Mesh
class_name ImmediateMesh

## Mesh optimized for creating geometry manually.
##
## A mesh type optimized for creating geometry manually, similar to OpenGL 1.x immediate mode.
## Here's a sample on how to generate a triangular face:
## [codeblocks]
## [gdscript]
## var mesh = ImmediateMesh.new()
## mesh.surface_begin(Mesh.PRIMITIVE_TRIANGLES)
## mesh.surface_add_vertex(Vector3.LEFT)
## mesh.surface_add_vertex(Vector3.FORWARD)
## mesh.surface_add_vertex(Vector3.ZERO)
## mesh.surface_end()
## [/gdscript]
## [csharp]
## var mesh = new ImmediateMesh();
## mesh.SurfaceBegin(Mesh.PrimitiveType.Triangles);
## mesh.SurfaceAddVertex(Vector3.Left);
## mesh.SurfaceAddVertex(Vector3.Forward);
## mesh.SurfaceAddVertex(Vector3.Zero);
## mesh.SurfaceEnd();
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] Generating complex geometries with [ImmediateMesh] is highly inefficient. Instead, it is designed to generate simple geometry that changes often.
##
## @tutorial(Using ImmediateMesh): https://docs.godotengine.org/en/stable/tutorials/3d/procedural_geometry/immediatemesh.html





## Clear all surfaces.
func clear_surfaces() -> void:
	pass;

## Add a 3D vertex using the current attributes previously set.
func surface_add_vertex(vertex: Vector3) -> void:
	pass;

## Add a 2D vertex using the current attributes previously set.
func surface_add_vertex_2d(vertex: Vector2) -> void:
	pass;

## Begin a new surface.
func surface_begin(primitive: int, material: Material = null) -> void:
	pass;

## End and commit current surface. Note that surface being created will not be visible until this function is called.
func surface_end() -> void:
	pass;

## Set the color attribute that will be pushed with the next vertex.
func surface_set_color(color: Color) -> void:
	pass;

## Set the normal attribute that will be pushed with the next vertex.
func surface_set_normal(normal: Vector3) -> void:
	pass;

## Set the tangent attribute that will be pushed with the next vertex.
func surface_set_tangent(tangent: Plane) -> void:
	pass;

## Set the UV attribute that will be pushed with the next vertex.
func surface_set_uv(uv: Vector2) -> void:
	pass;

## Set the UV2 attribute that will be pushed with the next vertex.
func surface_set_uv2(uv2: Vector2) -> void:
	pass;


