extends Object
class_name Geometry2D

## Provides methods for some common 2D geometric operations.
##
## Provides a set of helper functions to create geometric shapes, compute intersections between shapes, and process various other geometric operations in 2D.


## Create regions where either subject or clip polygons (or both) are filled.
## Create regions where subject polygons are filled except where clip polygons are filled.
## Create regions where both subject and clip polygons are filled.
## Create regions where either subject or clip polygons are filled but not where both are filled.
## Squaring is applied uniformally at all convex edge joins at [code]1 * delta[/code].
## While flattened paths can never perfectly trace an arc, they are approximated by a series of arc chords.
## There's a necessary limit to mitered joins since offsetting edges that join at very acute angles will produce excessively long and narrow "spikes". For any given edge join, when miter offsetting would exceed that maximum distance, "square" joining is applied.
## Endpoints are joined using the [enum PolyJoinType] value and the path filled as a polygon.
## Endpoints are joined using the [enum PolyJoinType] value and the path filled as a polyline.
## Endpoints are squared off with no extension.
## Endpoints are squared off and extended by [code]delta[/code] units.
## Endpoints are rounded off and extended by [code]delta[/code] units.

#enum PolyBooleanOperation
enum {
    OPERATION_UNION = 0,
    OPERATION_DIFFERENCE = 1,
    OPERATION_INTERSECTION = 2,
    OPERATION_XOR = 3,
}
#enum PolyJoinType
enum {
    JOIN_SQUARE = 0,
    JOIN_ROUND = 1,
    JOIN_MITER = 2,
}
#enum PolyEndType
enum {
    END_POLYGON = 0,
    END_JOINED = 1,
    END_BUTT = 2,
    END_SQUARE = 3,
    END_ROUND = 4,
}


## Clips [param polygon_a] against [param polygon_b] and returns an array of clipped polygons. This performs [constant OPERATION_DIFFERENCE] between polygons. Returns an empty array if [param polygon_b] completely overlaps [param polygon_a].
## If [param polygon_b] is enclosed by [param polygon_a], returns an outer polygon (boundary) and inner polygon (hole) which could be distinguished by calling [method is_polygon_clockwise].
func clip_polygons(polygon_a: PackedVector2Array, polygon_b: PackedVector2Array) -> Array[PackedVector2Array]:
	pass;

## Clips [param polyline] against [param polygon] and returns an array of clipped polylines. This performs [constant OPERATION_DIFFERENCE] between the polyline and the polygon. This operation can be thought of as cutting a line with a closed shape.
func clip_polyline_with_polygon(polyline: PackedVector2Array, polygon: PackedVector2Array) -> Array[PackedVector2Array]:
	pass;

## Given an array of [Vector2]s, returns the convex hull as a list of points in counterclockwise order. The last point is the same as the first one.
func convex_hull(points: PackedVector2Array) -> PackedVector2Array:
	pass;

## Decomposes the [param polygon] into multiple convex hulls and returns an array of [PackedVector2Array].
func decompose_polygon_in_convex(polygon: PackedVector2Array) -> Array[PackedVector2Array]:
	pass;

## Mutually excludes common area defined by intersection of [param polygon_a] and [param polygon_b] (see [method intersect_polygons]) and returns an array of excluded polygons. This performs [constant OPERATION_XOR] between polygons. In other words, returns all but common area between polygons.
## The operation may result in an outer polygon (boundary) and inner polygon (hole) produced which could be distinguished by calling [method is_polygon_clockwise].
func exclude_polygons(polygon_a: PackedVector2Array, polygon_b: PackedVector2Array) -> Array[PackedVector2Array]:
	pass;

## Returns the 2D point on the 2D segment ([param s1], [param s2]) that is closest to [param point]. The returned point will always be inside the specified segment.
func get_closest_point_to_segment(point: Vector2, s1: Vector2, s2: Vector2) -> Vector2:
	pass;

## Returns the 2D point on the 2D line defined by ([param s1], [param s2]) that is closest to [param point]. The returned point can be inside the segment ([param s1], [param s2]) or outside of it, i.e. somewhere on the line extending from the segment.
func get_closest_point_to_segment_uncapped(point: Vector2, s1: Vector2, s2: Vector2) -> Vector2:
	pass;

## Given the two 2D segments ([param p1], [param q1]) and ([param p2], [param q2]), finds those two points on the two segments that are closest to each other. Returns a [PackedVector2Array] that contains this point on ([param p1], [param q1]) as well the accompanying point on ([param p2], [param q2]).
func get_closest_points_between_segments(p1: Vector2, q1: Vector2, p2: Vector2, q2: Vector2) -> PackedVector2Array:
	pass;

## Intersects [param polygon_a] with [param polygon_b] and returns an array of intersected polygons. This performs [constant OPERATION_INTERSECTION] between polygons. In other words, returns common area shared by polygons. Returns an empty array if no intersection occurs.
## The operation may result in an outer polygon (boundary) and inner polygon (hole) produced which could be distinguished by calling [method is_polygon_clockwise].
func intersect_polygons(polygon_a: PackedVector2Array, polygon_b: PackedVector2Array) -> Array[PackedVector2Array]:
	pass;

## Intersects [param polyline] with [param polygon] and returns an array of intersected polylines. This performs [constant OPERATION_INTERSECTION] between the polyline and the polygon. This operation can be thought of as chopping a line with a closed shape.
func intersect_polyline_with_polygon(polyline: PackedVector2Array, polygon: PackedVector2Array) -> Array[PackedVector2Array]:
	pass;

## Returns [code]true[/code] if [param point] is inside the circle or if it's located exactly [i]on[/i] the circle's boundary, otherwise returns [code]false[/code].
func is_point_in_circle(point: Vector2, circle_position: Vector2, circle_radius: float) -> bool:
	pass;

## Returns [code]true[/code] if [param point] is inside [param polygon] or if it's located exactly [i]on[/i] polygon's boundary, otherwise returns [code]false[/code].
func is_point_in_polygon(point: Vector2, polygon: PackedVector2Array) -> bool:
	pass;

## Returns [code]true[/code] if [param polygon]'s vertices are ordered in clockwise order, otherwise returns [code]false[/code].
## [b]Note:[/b] Assumes a Cartesian coordinate system where [code]+x[/code] is right and [code]+y[/code] is up. If using screen coordinates ([code]+y[/code] is down), the result will need to be flipped (i.e. a [code]true[/code] result will indicate counter-clockwise).
func is_polygon_clockwise(polygon: PackedVector2Array) -> bool:
	pass;

## Checks if the two lines ([param from_a], [param dir_a]) and ([param from_b], [param dir_b]) intersect. If yes, return the point of intersection as [Vector2]. If no intersection takes place, returns [code]null[/code].
## [b]Note:[/b] The lines are specified using direction vectors, not end points.
func line_intersects_line(from_a: Vector2, dir_a: Vector2, from_b: Vector2, dir_b: Vector2) -> Variant:
	pass;

## Given an array of [Vector2]s representing tiles, builds an atlas. The returned dictionary has two keys: [code]points[/code] is a [PackedVector2Array] that specifies the positions of each tile, [code]size[/code] contains the overall size of the whole atlas as [Vector2i].
func make_atlas(sizes: PackedVector2Array) -> Dictionary:
	pass;

## Merges (combines) [param polygon_a] and [param polygon_b] and returns an array of merged polygons. This performs [constant OPERATION_UNION] between polygons.
## The operation may result in an outer polygon (boundary) and multiple inner polygons (holes) produced which could be distinguished by calling [method is_polygon_clockwise].
func merge_polygons(polygon_a: PackedVector2Array, polygon_b: PackedVector2Array) -> Array[PackedVector2Array]:
	pass;

## Inflates or deflates [param polygon] by [param delta] units (pixels). If [param delta] is positive, makes the polygon grow outward. If [param delta] is negative, shrinks the polygon inward. Returns an array of polygons because inflating/deflating may result in multiple discrete polygons. Returns an empty array if [param delta] is negative and the absolute value of it approximately exceeds the minimum bounding rectangle dimensions of the polygon.
## Each polygon's vertices will be rounded as determined by [param join_type], see [enum PolyJoinType].
## The operation may result in an outer polygon (boundary) and inner polygon (hole) produced which could be distinguished by calling [method is_polygon_clockwise].
## [b]Note:[/b] To translate the polygon's vertices specifically, multiply them to a [Transform2D]:
## [codeblocks]
## [gdscript]
## var polygon = PackedVector2Array([Vector2(0, 0), Vector2(100, 0), Vector2(100, 100), Vector2(0, 100)])
## var offset = Vector2(50, 50)
## polygon = Transform2D(0, offset) * polygon
## print(polygon) # prints [(50, 50), (150, 50), (150, 150), (50, 150)]
## [/gdscript]
## [csharp]
## var polygon = new Vector2[] { new Vector2(0, 0), new Vector2(100, 0), new Vector2(100, 100), new Vector2(0, 100) };
## var offset = new Vector2(50, 50);
## polygon = new Transform2D(0, offset) * polygon;
## GD.Print((Variant)polygon); // prints [(50, 50), (150, 50), (150, 150), (50, 150)]
## [/csharp]
## [/codeblocks]
func offset_polygon(polygon: PackedVector2Array, delta: float, join_type: int = 0) -> Array[PackedVector2Array]:
	pass;

## Inflates or deflates [param polyline] by [param delta] units (pixels), producing polygons. If [param delta] is positive, makes the polyline grow outward. Returns an array of polygons because inflating/deflating may result in multiple discrete polygons. If [param delta] is negative, returns an empty array.
## Each polygon's vertices will be rounded as determined by [param join_type], see [enum PolyJoinType].
## Each polygon's endpoints will be rounded as determined by [param end_type], see [enum PolyEndType].
## The operation may result in an outer polygon (boundary) and inner polygon (hole) produced which could be distinguished by calling [method is_polygon_clockwise].
func offset_polyline(polyline: PackedVector2Array, delta: float, join_type: int = 0, end_type: int = 3) -> Array[PackedVector2Array]:
	pass;

## Returns if [param point] is inside the triangle specified by [param a], [param b] and [param c].
func point_is_inside_triangle(point: Vector2, a: Vector2, b: Vector2, c: Vector2) -> bool:
	pass;

## Given the 2D segment ([param segment_from], [param segment_to]), returns the position on the segment (as a number between 0 and 1) at which the segment hits the circle that is located at position [param circle_position] and has radius [param circle_radius]. If the segment does not intersect the circle, -1 is returned (this is also the case if the line extending the segment would intersect the circle, but the segment does not).
func segment_intersects_circle(segment_from: Vector2, segment_to: Vector2, circle_position: Vector2, circle_radius: float) -> float:
	pass;

## Checks if the two segments ([param from_a], [param to_a]) and ([param from_b], [param to_b]) intersect. If yes, return the point of intersection as [Vector2]. If no intersection takes place, returns [code]null[/code].
func segment_intersects_segment(from_a: Vector2, to_a: Vector2, from_b: Vector2, to_b: Vector2) -> Variant:
	pass;

## Triangulates the area specified by discrete set of [param points] such that no point is inside the circumcircle of any resulting triangle. Returns a [PackedInt32Array] where each triangle consists of three consecutive point indices into [param points] (i.e. the returned array will have [code]n * 3[/code] elements, with [code]n[/code] being the number of found triangles). If the triangulation did not succeed, an empty [PackedInt32Array] is returned.
func triangulate_delaunay(points: PackedVector2Array) -> PackedInt32Array:
	pass;

## Triangulates the polygon specified by the points in [param polygon]. Returns a [PackedInt32Array] where each triangle consists of three consecutive point indices into [param polygon] (i.e. the returned array will have [code]n * 3[/code] elements, with [code]n[/code] being the number of found triangles). Output triangles will always be counter clockwise, and the contour will be flipped if it's clockwise. If the triangulation did not succeed, an empty [PackedInt32Array] is returned.
func triangulate_polygon(polygon: PackedVector2Array) -> PackedInt32Array:
	pass;


