extends GPUParticlesAttractor3D
class_name GPUParticlesAttractorVectorField3D

## A box-shaped attractor with varying directions and strengths defined in it that influences particles from [GPUParticles3D] nodes.
##
## A box-shaped attractor with varying directions and strengths defined in it that influences particles from [GPUParticles3D] nodes.
## Unlike [GPUParticlesAttractorBox3D], [GPUParticlesAttractorVectorField3D] uses a [member texture] to affect attraction strength within the box. This can be used to create complex attraction scenarios where particles travel in different directions depending on their location. This can be useful for weather effects such as sandstorms.
## Particle attractors work in real-time and can be moved, rotated and scaled during gameplay. Unlike collision shapes, non-uniform scaling of attractors is also supported.
## [b]Note:[/b] Particle attractors only affect [GPUParticles3D], not [CPUParticles3D].



## The size of the vector field box in 3D units.
var size: Vector3:
	get = get_size, set = set_size

## The 3D texture to be used. Values are linearly interpolated between the texture's pixels.
## [b]Note:[/b] To get better performance, the 3D texture's resolution should reflect the [member size] of the attractor. Since particle attraction is usually low-frequency data, the texture can be kept at a low resolution such as 64×64×64.
var texture: Texture3D:
	get = get_texture, set = set_texture




func get_size() -> Vector3:
	return size

func set_size(value: Vector3) -> void:
	size = value

func get_texture() -> Texture3D:
	return texture

func set_texture(value: Texture3D) -> void:
	texture = value

