extends GPUParticlesAttractor3D
class_name GPUParticlesAttractorSphere3D

## A spheroid-shaped attractor that influences particles from [GPUParticles3D] nodes.
##
## A spheroid-shaped attractor that influences particles from [GPUParticles3D] nodes. Can be used to attract particles towards its origin, or to push them away from its origin.
## Particle attractors work in real-time and can be moved, rotated and scaled during gameplay. Unlike collision shapes, non-uniform scaling of attractors is also supported.
## [b]Note:[/b] Particle attractors only affect [GPUParticles3D], not [CPUParticles3D].



## The attractor sphere's radius in 3D units.
## [b]Note:[/b] Stretched ellipses can be obtained by using non-uniform scaling on the [GPUParticlesAttractorSphere3D] node.
var radius: float:
	get = get_radius, set = set_radius




func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

