extends Resource
class_name GLTFPhysicsBody

## Represents a GLTF physics body.
##
## Represents a physics body as an intermediary between the [code]OMI_physics_body[/code] GLTF data and Godot's nodes, and it's abstracted in a way that allows adding support for different GLTF physics extensions in the future.
##
## @tutorial(Runtime file loading and saving): https://docs.godotengine.org/en/stable/tutorials/io/runtime_file_loading_and_saving.html
## @tutorial(OMI_physics_body GLTF extension): https://github.com/omigroup/gltf-extensions/tree/main/extensions/2.0/OMI_physics_body



## The angular velocity of the physics body, in radians per second. This is only used when the body type is "rigid" or "vehicle".
var angular_velocity: Vector3:
	get = get_angular_velocity, set = set_angular_velocity

## The type of the body. When importing, this controls what type of [CollisionObject3D] node Godot should generate. Valid values are "static", "animatable", "character", "rigid", "vehicle", and "trigger". When exporting, this will be squashed down to one of "static", "kinematic", or "dynamic" motion types, or the "trigger" property.
var body_type: String:
	get = get_body_type, set = set_body_type

## The center of mass of the body, in meters. This is in local space relative to the body. By default, the center of the mass is the body's origin.
var center_of_mass: Vector3:
	get = get_center_of_mass, set = set_center_of_mass

## The inertia strength of the physics body, in kilogram meter squared (kg⋅m²). This represents the inertia around the principle axes, the diagonal of the inertia tensor matrix. This is only used when the body type is "rigid" or "vehicle".
## When converted to a Godot [RigidBody3D] node, if this value is zero, then the inertia will be calculated automatically.
var inertia_diagonal: Vector3:
	get = get_inertia_diagonal, set = set_inertia_diagonal

## The inertia orientation of the physics body. This defines the rotation of the inertia's principle axes relative to the object's local axes. This is only used when the body type is "rigid" or "vehicle" and [member inertia_diagonal] is set to a non-zero value.
var inertia_orientation: Quaternion:
	get = get_inertia_orientation, set = set_inertia_orientation

## The inertia tensor of the physics body, in kilogram meter squared (kg⋅m²). This is only used when the body type is "rigid" or "vehicle".
## When converted to a Godot [RigidBody3D] node, if this value is zero, then the inertia will be calculated automatically.
var inertia_tensor: Basis:
	get = get_inertia_tensor, set = set_inertia_tensor

## The linear velocity of the physics body, in meters per second. This is only used when the body type is "rigid" or "vehicle".
var linear_velocity: Vector3:
	get = get_linear_velocity, set = set_linear_velocity

## The mass of the physics body, in kilograms. This is only used when the body type is "rigid" or "vehicle".
var mass: float:
	get = get_mass, set = set_mass



## Creates a new GLTFPhysicsBody instance by parsing the given [Dictionary] in the [code]OMI_physics_body[/code] GLTF extension format.
static func from_dictionary(dictionary: Dictionary) -> GLTFPhysicsBody:
	pass;

## Creates a new GLTFPhysicsBody instance from the given Godot [CollisionObject3D] node.
static func from_node(body_node: CollisionObject3D) -> GLTFPhysicsBody:
	pass;

## Serializes this GLTFPhysicsBody instance into a [Dictionary]. It will be in the format expected by the [code]OMI_physics_body[/code] GLTF extension.
func to_dictionary() -> Dictionary:
	pass;

## Converts this GLTFPhysicsBody instance into a Godot [CollisionObject3D] node.
func to_node() -> CollisionObject3D:
	pass;


func get_angular_velocity() -> Vector3:
	return angular_velocity

func set_angular_velocity(value: Vector3) -> void:
	angular_velocity = value

func get_body_type() -> String:
	return body_type

func set_body_type(value: String) -> void:
	body_type = value

func get_center_of_mass() -> Vector3:
	return center_of_mass

func set_center_of_mass(value: Vector3) -> void:
	center_of_mass = value

func get_inertia_diagonal() -> Vector3:
	return inertia_diagonal

func set_inertia_diagonal(value: Vector3) -> void:
	inertia_diagonal = value

func get_inertia_orientation() -> Quaternion:
	return inertia_orientation

func set_inertia_orientation(value: Quaternion) -> void:
	inertia_orientation = value

func get_inertia_tensor() -> Basis:
	return inertia_tensor

func set_inertia_tensor(value: Basis) -> void:
	inertia_tensor = value

func get_linear_velocity() -> Vector3:
	return linear_velocity

func set_linear_velocity(value: Vector3) -> void:
	linear_velocity = value

func get_mass() -> float:
	return mass

func set_mass(value: float) -> void:
	mass = value

