extends Resource
class_name GLTFBufferView

## Represents a GLTF buffer view.
##
## GLTFBufferView is a data structure representing GLTF a [code]bufferView[/code] that would be found in the [code]"bufferViews"[/code] array. A buffer is a blob of binary data. A buffer view is a slice of a buffer that can be used to identify and extract data from the buffer.
## Most custom uses of buffers only need to use the [member buffer], [member byte_length], and [member byte_offset]. The [member byte_stride] and [member indices] properties are for more advanced use cases such as interleaved mesh data encoded for the GPU.
##
## @tutorial(Buffers, BufferViews, and Accessors in Khronos glTF specification): https://github.com/KhronosGroup/glTF-Tutorials/blob/master/gltfTutorial/gltfTutorial_005_BuffersBufferViewsAccessors.md
## @tutorial(Runtime file loading and saving): https://docs.godotengine.org/en/stable/tutorials/io/runtime_file_loading_and_saving.html



## The index of the buffer this buffer view is referencing. If [code]-1[/code], this buffer view is not referencing any buffer.
var buffer: int:
	get = get_buffer, set = set_buffer

## The length, in bytes, of this buffer view. If [code]0[/code], this buffer view is empty.
var byte_length: int:
	get = get_byte_length, set = set_byte_length

## The offset, in bytes, from the start of the buffer to the start of this buffer view.
var byte_offset: int:
	get = get_byte_offset, set = set_byte_offset

## The stride, in bytes, between interleaved data. If [code]-1[/code], this buffer view is not interleaved.
var byte_stride: int:
	get = get_byte_stride, set = set_byte_stride

## True if the GLTFBufferView's OpenGL GPU buffer type is an [code]ELEMENT_ARRAY_BUFFER[/code] used for vertex indices (integer constant [code]34963[/code]). False if the buffer type is any other value. See [url=https://github.com/KhronosGroup/glTF-Tutorials/blob/master/gltfTutorial/gltfTutorial_005_BuffersBufferViewsAccessors.md]Buffers, BufferViews, and Accessors[/url] for possible values. This property is set on import and used on export.
var indices: bool:
	get = get_indices, set = set_indices

## True if the GLTFBufferView's OpenGL GPU buffer type is an [code]ARRAY_BUFFER[/code] used for vertex attributes (integer constant [code]34962[/code]). False if the buffer type is any other value. See [url=https://github.com/KhronosGroup/glTF-Tutorials/blob/master/gltfTutorial/gltfTutorial_005_BuffersBufferViewsAccessors.md]Buffers, BufferViews, and Accessors[/url] for possible values. This property is set on import and used on export.
var vertex_attributes: bool:
	get = get_vertex_attributes, set = set_vertex_attributes



## Loads the buffer view data from the buffer referenced by this buffer view in the given [GLTFState]. Interleaved data with a byte stride is not yet supported by this method. The data is returned as a [PackedByteArray].
func load_buffer_view_data(state: GLTFState) -> PackedByteArray:
	pass;


func get_buffer() -> int:
	return buffer

func set_buffer(value: int) -> void:
	buffer = value

func get_byte_length() -> int:
	return byte_length

func set_byte_length(value: int) -> void:
	byte_length = value

func get_byte_offset() -> int:
	return byte_offset

func set_byte_offset(value: int) -> void:
	byte_offset = value

func get_byte_stride() -> int:
	return byte_stride

func set_byte_stride(value: int) -> void:
	byte_stride = value

func get_indices() -> bool:
	return indices

func set_indices(value: bool) -> void:
	indices = value

func get_vertex_attributes() -> bool:
	return vertex_attributes

func set_vertex_attributes(value: bool) -> void:
	vertex_attributes = value

