extends Resource
class_name GLTFAnimation

## @tutorial(Runtime file loading and saving): https://docs.godotengine.org/en/stable/tutorials/io/runtime_file_loading_and_saving.html



var loop: bool:
	get = get_loop, set = set_loop

## The original name of the animation.
var original_name: String:
	get = get_original_name, set = set_original_name



## Gets additional arbitrary data in this [GLTFAnimation] instance. This can be used to keep per-node state data in [GLTFDocumentExtension] classes, which is important because they are stateless.
## The argument should be the [GLTFDocumentExtension] name (does not have to match the extension name in the GLTF file), and the return value can be anything you set. If nothing was set, the return value is null.
func get_additional_data(extension_name: StringName) -> Variant:
	pass;

## Sets additional arbitrary data in this [GLTFAnimation] instance. This can be used to keep per-node state data in [GLTFDocumentExtension] classes, which is important because they are stateless.
## The first argument should be the [GLTFDocumentExtension] name (does not have to match the extension name in the GLTF file), and the second argument can be anything you want.
func set_additional_data(extension_name: StringName, additional_data: Variant) -> void:
	pass;


func get_loop() -> bool:
	return loop

func set_loop(value: bool) -> void:
	loop = value

func get_original_name() -> String:
	return original_name

func set_original_name(value: String) -> void:
	original_name = value

