extends Object
class_name GDExtensionManager

## Provides access to GDExtension functionality.
##
## The GDExtensionManager loads, initializes, and keeps track of all available [GDExtension] libraries in the project.
## [b]Note:[/b] Do not worry about GDExtension unless you know what you are doing.
##
## @tutorial(GDExtension overview): https://docs.godotengine.org/en/stable/tutorials/scripting/gdextension/what_is_gdextension.html
## @tutorial(GDExtension example in C++): https://docs.godotengine.org/en/stable/tutorials/scripting/gdextension/gdextension_cpp_example.html


## Emitted after the editor has finished reloading one or more extensions.
signal extensions_reloaded
## The extension has loaded successfully.
## The extension has failed to load, possibly because it does not exist or has missing dependencies.
## The extension has already been loaded.
## The extension has not been loaded.
## The extension requires the application to restart to fully load.

#enum LoadStatus
enum {
    LOAD_STATUS_OK = 0,
    LOAD_STATUS_FAILED = 1,
    LOAD_STATUS_ALREADY_LOADED = 2,
    LOAD_STATUS_NOT_LOADED = 3,
    LOAD_STATUS_NEEDS_RESTART = 4,
}


## Returns the [GDExtension] at the given file [param path], or [code]null[/code] if it has not been loaded or does not exist.
func get_extension(path: String) -> GDExtension:
	pass;

## Returns the file paths of all currently loaded extensions.
func get_loaded_extensions() -> PackedStringArray:
	pass;

## Returns [code]true[/code] if the extension at the given file [param path] has already been loaded successfully. See also [method get_loaded_extensions].
func is_extension_loaded(path: String) -> bool:
	pass;

## Loads an extension by absolute file path. The [param path] needs to point to a valid [GDExtension]. Returns [constant LOAD_STATUS_OK] if successful.
func load_extension(path: String) -> int:
	pass;

## Reloads the extension at the given file path. The [param path] needs to point to a valid [GDExtension], otherwise this method may return either [constant LOAD_STATUS_NOT_LOADED] or [constant LOAD_STATUS_FAILED].
## [b]Note:[/b] You can only reload extensions in the editor. In release builds, this method always fails and returns [constant LOAD_STATUS_FAILED].
func reload_extension(path: String) -> int:
	pass;

## Unloads an extension by file path. The [param path] needs to point to an already loaded [GDExtension], otherwise this method returns [constant LOAD_STATUS_NOT_LOADED].
func unload_extension(path: String) -> int:
	pass;


