extends Resource
class_name GDExtension

## A native library for GDExtension.
##
## The [GDExtension] resource type represents a [url=https://en.wikipedia.org/wiki/Shared_library]shared library[/url] which can expand the functionality of the engine. The [GDExtensionManager] singleton is responsible for loading, reloading, and unloading [GDExtension] resources.
## [b]Note:[/b] GDExtension itself is not a scripting language and has no relation to [GDScript] resources.
##
## @tutorial(GDExtension overview): https://docs.godotengine.org/en/stable/tutorials/scripting/gdextension/what_is_gdextension.html
## @tutorial(GDExtension example in C++): https://docs.godotengine.org/en/stable/tutorials/scripting/gdextension/gdextension_cpp_example.html


## The library is initialized at the same time as the core features of the engine.
## The library is initialized at the same time as the engine's servers (such as [RenderingServer] or [PhysicsServer3D]).
## The library is initialized at the same time as the engine's scene-related classes.
## The library is initialized at the same time as the engine's editor classes. Only happens when loading the GDExtension in the editor.

#enum InitializationLevel
enum {
    INITIALIZATION_LEVEL_CORE = 0,
    INITIALIZATION_LEVEL_SERVERS = 1,
    INITIALIZATION_LEVEL_SCENE = 2,
    INITIALIZATION_LEVEL_EDITOR = 3,
}


## Returns the lowest level required for this extension to be properly initialized (see the [enum InitializationLevel] enum).
func get_minimum_library_initialization_level() -> int:
	pass;

## Returns [code]true[/code] if this extension's library has been opened.
func is_library_open() -> bool:
	pass;


