extends Resource
class_name Font

## Abstract base class for fonts and font variations.
##
## Abstract base class for different font types. It has methods for drawing text and font character introspection.



## Array of fallback [Font]s to use as a substitute if a glyph is not found in this current [Font].
## If this array is empty in a [FontVariation], the [member FontVariation.base_font]'s fallbacks are used instead.
var fallbacks: Array[Font]:
	get = get_fallbacks, set = set_fallbacks



## Draw a single Unicode character [param char] into a canvas item using the font, at a given position, with [param modulate] color. [param pos] specifies the baseline, not the top. To draw from the top, [i]ascent[/i] must be added to the Y axis.
## [b]Note:[/b] Do not use this function to draw strings character by character, use [method draw_string] or [TextLine] instead.
func draw_char(canvas_item: RID, pos: Vector2, char: int, font_size: int, modulate: Color = Color(1, 1, 1, 1)) -> float:
	pass;

## Draw a single Unicode character [param char] outline into a canvas item using the font, at a given position, with [param modulate] color and [param size] outline size. [param pos] specifies the baseline, not the top. To draw from the top, [i]ascent[/i] must be added to the Y axis.
## [b]Note:[/b] Do not use this function to draw strings character by character, use [method draw_string] or [TextLine] instead.
func draw_char_outline(canvas_item: RID, pos: Vector2, char: int, font_size: int, size: int = -1, modulate: Color = Color(1, 1, 1, 1)) -> float:
	pass;

## Breaks [param text] into lines using rules specified by [param brk_flags] and draws it into a canvas item using the font, at a given position, with [param modulate] color, optionally clipping the width and aligning horizontally. [param pos] specifies the baseline of the first line, not the top. To draw from the top, [i]ascent[/i] must be added to the Y axis.
## See also [method CanvasItem.draw_multiline_string].
func draw_multiline_string(canvas_item: RID, pos: Vector2, text: String, alignment: int = 0, width: float = -1, font_size: int = 16, max_lines: int = -1, modulate: Color = Color(1, 1, 1, 1), brk_flags: int = 3, justification_flags: int = 3, direction: int = 0, orientation: int = 0) -> void:
	pass;

## Breaks [param text] to the lines using rules specified by [param brk_flags] and draws text outline into a canvas item using the font, at a given position, with [param modulate] color and [param size] outline size, optionally clipping the width and aligning horizontally. [param pos] specifies the baseline of the first line, not the top. To draw from the top, [i]ascent[/i] must be added to the Y axis.
## See also [method CanvasItem.draw_multiline_string_outline].
func draw_multiline_string_outline(canvas_item: RID, pos: Vector2, text: String, alignment: int = 0, width: float = -1, font_size: int = 16, max_lines: int = -1, size: int = 1, modulate: Color = Color(1, 1, 1, 1), brk_flags: int = 3, justification_flags: int = 3, direction: int = 0, orientation: int = 0) -> void:
	pass;

## Draw [param text] into a canvas item using the font, at a given position, with [param modulate] color, optionally clipping the width and aligning horizontally. [param pos] specifies the baseline, not the top. To draw from the top, [i]ascent[/i] must be added to the Y axis.
## See also [method CanvasItem.draw_string].
func draw_string(canvas_item: RID, pos: Vector2, text: String, alignment: int = 0, width: float = -1, font_size: int = 16, modulate: Color = Color(1, 1, 1, 1), justification_flags: int = 3, direction: int = 0, orientation: int = 0) -> void:
	pass;

## Draw [param text] outline into a canvas item using the font, at a given position, with [param modulate] color and [param size] outline size, optionally clipping the width and aligning horizontally. [param pos] specifies the baseline, not the top. To draw from the top, [i]ascent[/i] must be added to the Y axis.
## See also [method CanvasItem.draw_string_outline].
func draw_string_outline(canvas_item: RID, pos: Vector2, text: String, alignment: int = 0, width: float = -1, font_size: int = 16, size: int = 1, modulate: Color = Color(1, 1, 1, 1), justification_flags: int = 3, direction: int = 0, orientation: int = 0) -> void:
	pass;

## Returns [TextServer] RID of the font cache for specific variation.
func find_variation(variation_coordinates: Dictionary, face_index: int = 0, strength: float = 0.0, transform: Transform2D = Transform2D(1, 0, 0, 1, 0, 0), spacing_top: int = 0, spacing_bottom: int = 0, spacing_space: int = 0, spacing_glyph: int = 0, baseline_offset: float = 0.0) -> RID:
	pass;

## Returns the average font ascent (number of pixels above the baseline).
## [b]Note:[/b] Real ascent of the string is context-dependent and can be significantly different from the value returned by this function. Use it only as rough estimate (e.g. as the ascent of empty line).
func get_ascent(font_size: int = 16) -> float:
	pass;

## Returns the size of a character. Does not take kerning into account.
## [b]Note:[/b] Do not use this function to calculate width of the string character by character, use [method get_string_size] or [TextLine] instead. The height returned is the font height (see also [method get_height]) and has no relation to the glyph height.
func get_char_size(char: int, font_size: int) -> Vector2:
	pass;

## Returns the average font descent (number of pixels below the baseline).
## [b]Note:[/b] Real descent of the string is context-dependent and can be significantly different from the value returned by this function. Use it only as rough estimate (e.g. as the descent of empty line).
func get_descent(font_size: int = 16) -> float:
	pass;

## Returns number of faces in the TrueType / OpenType collection.
func get_face_count() -> int:
	pass;

## Returns font family name.
func get_font_name() -> String:
	pass;

## Returns font stretch amount, compared to a normal width. A percentage value between [code]50%[/code] and [code]200%[/code].
func get_font_stretch() -> int:
	pass;

## Returns font style flags, see [enum TextServer.FontStyle].
func get_font_style() -> int:
	pass;

## Returns font style name.
func get_font_style_name() -> String:
	pass;

## Returns weight (boldness) of the font. A value in the [code]100...999[/code] range, normal font weight is [code]400[/code], bold font weight is [code]700[/code].
func get_font_weight() -> int:
	pass;

## Returns the total average font height (ascent plus descent) in pixels.
## [b]Note:[/b] Real height of the string is context-dependent and can be significantly different from the value returned by this function. Use it only as rough estimate (e.g. as the height of empty line).
func get_height(font_size: int = 16) -> float:
	pass;

## Returns the size of a bounding box of a string broken into the lines, taking kerning and advance into account.
## See also [method draw_multiline_string].
func get_multiline_string_size(text: String, alignment: int = 0, width: float = -1, font_size: int = 16, max_lines: int = -1, brk_flags: int = 3, justification_flags: int = 3, direction: int = 0, orientation: int = 0) -> Vector2:
	pass;

## Returns a set of OpenType feature tags. More info: [url=https://docs.microsoft.com/en-us/typography/opentype/spec/featuretags]OpenType feature tags[/url].
func get_opentype_features() -> Dictionary:
	pass;

## Returns [Dictionary] with OpenType font name strings (localized font names, version, description, license information, sample text, etc.).
func get_ot_name_strings() -> Dictionary:
	pass;

## Returns [Array] of valid [Font] [RID]s, which can be passed to the [TextServer] methods.
func get_rids() -> Array[RID]:
	pass;

## Returns the spacing for the given [code]type[/code] (see [enum TextServer.SpacingType]).
func get_spacing(spacing: int) -> int:
	pass;

## Returns the size of a bounding box of a single-line string, taking kerning, advance and subpixel positioning into account. See also [method get_multiline_string_size] and [method draw_string].
## For example, to get the string size as displayed by a single-line Label, use:
## [codeblocks]
## [gdscript]
## var string_size = $Label.get_theme_font("font").get_string_size($Label.text, HORIZONTAL_ALIGNMENT_LEFT, -1, $Label.get_theme_font_size("font_size"))
## [/gdscript]
## [csharp]
## Label label = GetNode<Label>("Label");
## Vector2 stringSize = label.GetThemeFont("font").GetStringSize(label.Text, HorizontalAlignment.Left, -1, label.GetThemeFontSize("font_size"));
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] Since kerning, advance and subpixel positioning are taken into account by [method get_string_size], using separate [method get_string_size] calls on substrings of a string then adding the results together will return a different result compared to using a single [method get_string_size] call on the full string.
## [b]Note:[/b] Real height of the string is context-dependent and can be significantly different from the value returned by [method get_height].
func get_string_size(text: String, alignment: int = 0, width: float = -1, font_size: int = 16, justification_flags: int = 3, direction: int = 0, orientation: int = 0) -> Vector2:
	pass;

## Returns a string containing all the characters available in the font.
## If a given character is included in more than one font data source, it appears only once in the returned string.
func get_supported_chars() -> String:
	pass;

## Returns list of OpenType features supported by font.
func get_supported_feature_list() -> Dictionary:
	pass;

## Returns list of supported [url=https://docs.microsoft.com/en-us/typography/opentype/spec/dvaraxisreg]variation coordinates[/url], each coordinate is returned as [code]tag: Vector3i(min_value,max_value,default_value)[/code].
## Font variations allow for continuous change of glyph characteristics along some given design axis, such as weight, width or slant.
## To print available variation axes of a variable font:
## [codeblock]
## var fv = FontVariation.new()
## fv.base_font = load("res://RobotoFlex.ttf")
## var variation_list = fv.get_supported_variation_list()
## for tag in variation_list:
## var name = TextServerManager.get_primary_interface().tag_to_name(tag)
## var values = variation_list[tag]
## print("variation axis: %s (%d)\n\tmin, max, default: %s" % [name, tag, values])
## [/codeblock]
## [b]Note:[/b] To set and get variation coordinates of a [FontVariation], use [member FontVariation.variation_opentype].
func get_supported_variation_list() -> Dictionary:
	pass;

## Returns average pixel offset of the underline below the baseline.
## [b]Note:[/b] Real underline position of the string is context-dependent and can be significantly different from the value returned by this function. Use it only as rough estimate.
func get_underline_position(font_size: int = 16) -> float:
	pass;

## Returns average thickness of the underline.
## [b]Note:[/b] Real underline thickness of the string is context-dependent and can be significantly different from the value returned by this function. Use it only as rough estimate.
func get_underline_thickness(font_size: int = 16) -> float:
	pass;

## Returns [code]true[/code] if a Unicode [param char] is available in the font.
func has_char(char: int) -> bool:
	pass;

## Returns [code]true[/code], if font supports given language ([url=https://en.wikipedia.org/wiki/ISO_639-1]ISO 639[/url] code).
func is_language_supported(language: String) -> bool:
	pass;

## Returns [code]true[/code], if font supports given script ([url=https://en.wikipedia.org/wiki/ISO_15924]ISO 15924[/url] code).
func is_script_supported(script: String) -> bool:
	pass;

## Sets LRU cache capacity for [code]draw_*[/code] methods.
func set_cache_capacity(single_line: int, multi_line: int) -> void:
	pass;


func get_fallbacks() -> Array[Font]:
	return fallbacks

func set_fallbacks(value: Array[Font]) -> void:
	fallbacks = value

