extends ConfirmationDialog
class_name FileDialog

## A dialog for selecting files or directories in the filesystem.
##
## [FileDialog] is a preset dialog used to choose files and directories in the filesystem. It supports filter masks. [FileDialog] automatically sets its window title according to the [member file_mode]. If you want to use a custom title, disable this by setting [member mode_overrides_title] to [code]false[/code].


## Emitted when the user selects a directory.
signal dir_selected(dir: String)
## Emitted when the user selects a file by double-clicking it or pressing the [b]OK[/b] button.
signal file_selected(path: String)
## Emitted when the user selects multiple files.
signal files_selected(paths: PackedStringArray)
## The dialog allows selecting one, and only one file.
## The dialog allows selecting multiple files.
## The dialog only allows selecting a directory, disallowing the selection of any file.
## The dialog allows selecting one file or directory.
## The dialog will warn when a file exists.
## The dialog only allows accessing files under the [Resource] path ([code]res://[/code]).
## The dialog only allows accessing files under user data path ([code]user://[/code]).
## The dialog allows accessing files on the whole file system.

#enum FileMode
enum {
    FILE_MODE_OPEN_FILE = 0,
    FILE_MODE_OPEN_FILES = 1,
    FILE_MODE_OPEN_DIR = 2,
    FILE_MODE_OPEN_ANY = 3,
    FILE_MODE_SAVE_FILE = 4,
}
#enum Access
enum {
    ACCESS_RESOURCES = 0,
    ACCESS_USERDATA = 1,
    ACCESS_FILESYSTEM = 2,
}
## The file system access scope. See [enum Access] constants.
## [b]Warning:[/b] In Web builds, FileDialog cannot access the host file system. In sandboxed Linux and macOS environments, [member use_native_dialog] is automatically used to allow limited access to host file system.
var access: int:
	get = get_access, set = set_access

## The current working directory of the file dialog.
## [b]Note:[/b] For native file dialogs, this property is only treated as a hint and may not be respected by specific OS implementations.
var current_dir: String:
	get = get_current_dir, set = set_current_dir

## The currently selected file of the file dialog.
var current_file: String:
	get = get_current_file, set = set_current_file

## The currently selected file path of the file dialog.
var current_path: String:
	get = get_current_path, set = set_current_path

var dialog_hide_on_ok: bool:
	get = get_hide_on_ok, set = set_hide_on_ok

## The dialog's open or save mode, which affects the selection behavior. See [enum FileMode].
var file_mode: int:
	get = get_file_mode, set = set_file_mode

## The available file type filters. Each filter string in the array should be formatted like this: [code]*.txt,*.doc;Text Files[/code]. The description text of the filter is optional and can be omitted.
var filters: PackedStringArray:
	get = get_filters, set = set_filters

## If [code]true[/code], changing the [member file_mode] property will set the window title accordingly (e.g. setting [member file_mode] to [constant FILE_MODE_OPEN_FILE] will change the window title to "Open a File").
var mode_overrides_title: bool:
	get = is_mode_overriding_title, set = set_mode_overrides_title

## The number of additional [OptionButton]s and [CheckBox]es in the dialog.
var option_count: int:
	get = get_option_count, set = set_option_count

## If non-empty, the given sub-folder will be "root" of this [FileDialog], i.e. user won't be able to go to its parent directory.
## [b]Note:[/b] This property is ignored by native file dialogs.
var root_subfolder: String:
	get = get_root_subfolder, set = set_root_subfolder

## If [code]true[/code], the dialog will show hidden files.
## [b]Note:[/b] This property is ignored by native file dialogs on Linux.
var show_hidden_files: bool:
	get = is_showing_hidden_files, set = set_show_hidden_files

var title: String:
	get = get_title, set = set_title

## If [code]true[/code], [member access] is set to [constant ACCESS_FILESYSTEM], and it is supported by the current [DisplayServer], OS native dialog will be used instead of custom one.
## [b]Note:[/b] On Linux and macOS, sandboxed apps always use native dialogs to access the host file system.
## [b]Note:[/b] On macOS, sandboxed apps will save security-scoped bookmarks to retain access to the opened folders across multiple sessions. Use [method OS.get_granted_permissions] to get a list of saved bookmarks.
## [b]Note:[/b] Native dialogs are isolated from the base process, file dialog properties can't be modified once the dialog is shown.
var use_native_dialog: bool:
	get = get_use_native_dialog, set = set_use_native_dialog



## Adds a comma-delimited file name [param filter] option to the [FileDialog] with an optional [param description], which restricts what files can be picked.
## A [param filter] should be of the form [code]"filename.extension"[/code], where filename and extension can be [code]*[/code] to match any string. Filters starting with [code].[/code] (i.e. empty filenames) are not allowed.
## For example, a [param filter] of [code]"*.png, *.jpg"[/code] and a [param description] of [code]"Images"[/code] results in filter text "Images (*.png, *.jpg)".
func add_filter(filter: String, description: String = "") -> void:
	pass;

## Adds an additional [OptionButton] to the file dialog. If [param values] is empty, a [CheckBox] is added instead.
## [param default_value_index] should be an index of the value in the [param values]. If [param values] is empty it should be either [code]1[/code] (checked), or [code]0[/code] (unchecked).
func add_option(name: String, values: PackedStringArray, default_value_index: int) -> void:
	pass;

## Clear all the added filters in the dialog.
func clear_filters() -> void:
	pass;

## Clear all currently selected items in the dialog.
func deselect_all() -> void:
	pass;

## Returns the LineEdit for the selected file.
## [b]Warning:[/b] This is a required internal node, removing and freeing it may cause a crash. If you wish to hide it or any of its children, use their [member CanvasItem.visible] property.
func get_line_edit() -> LineEdit:
	pass;

## Returns the default value index of the [OptionButton] or [CheckBox] with index [param option].
func get_option_default(option: int) -> int:
	pass;

## Returns the name of the [OptionButton] or [CheckBox] with index [param option].
func get_option_name(option: int) -> String:
	pass;

## Returns an array of values of the [OptionButton] with index [param option].
func get_option_values(option: int) -> PackedStringArray:
	pass;

## Returns a [Dictionary] with the selected values of the additional [OptionButton]s and/or [CheckBox]es. [Dictionary] keys are names and values are selected value indices.
func get_selected_options() -> Dictionary:
	pass;

## Returns the vertical box container of the dialog, custom controls can be added to it.
## [b]Warning:[/b] This is a required internal node, removing and freeing it may cause a crash. If you wish to hide it or any of its children, use their [member CanvasItem.visible] property.
## [b]Note:[/b] Changes to this node are ignored by native file dialogs, use [method add_option] to add custom elements to the dialog instead.
func get_vbox() -> VBoxContainer:
	pass;

## Invalidate and update the current dialog content list.
## [b]Note:[/b] This method does nothing on native file dialogs.
func invalidate() -> void:
	pass;

## Sets the default value index of the [OptionButton] or [CheckBox] with index [param option].
func set_option_default(option: int, default_value_index: int) -> void:
	pass;

## Sets the name of the [OptionButton] or [CheckBox] with index [param option].
func set_option_name(option: int, name: String) -> void:
	pass;

## Sets the option values of the [OptionButton] with index [param option].
func set_option_values(option: int, values: PackedStringArray) -> void:
	pass;


func get_access() -> int:
	return access

func set_access(value: int) -> void:
	access = value

func get_current_dir() -> String:
	return current_dir

func set_current_dir(value: String) -> void:
	current_dir = value

func get_current_file() -> String:
	return current_file

func set_current_file(value: String) -> void:
	current_file = value

func get_current_path() -> String:
	return current_path

func set_current_path(value: String) -> void:
	current_path = value

func get_hide_on_ok() -> bool:
	return dialog_hide_on_ok

func set_hide_on_ok(value: bool) -> void:
	dialog_hide_on_ok = value

func get_file_mode() -> int:
	return file_mode

func set_file_mode(value: int) -> void:
	file_mode = value

func get_filters() -> PackedStringArray:
	return filters

func set_filters(value: PackedStringArray) -> void:
	filters = value

func is_mode_overriding_title() -> bool:
	return mode_overrides_title

func set_mode_overrides_title(value: bool) -> void:
	mode_overrides_title = value

func get_option_count() -> int:
	return option_count

func set_option_count(value: int) -> void:
	option_count = value

func get_root_subfolder() -> String:
	return root_subfolder

func set_root_subfolder(value: String) -> void:
	root_subfolder = value

func is_showing_hidden_files() -> bool:
	return show_hidden_files

func set_show_hidden_files(value: bool) -> void:
	show_hidden_files = value

func get_title() -> String:
	return title

func set_title(value: String) -> void:
	title = value

func get_use_native_dialog() -> bool:
	return use_native_dialog

func set_use_native_dialog(value: bool) -> void:
	use_native_dialog = value

