extends Object
class_name EditorInterface

## Godot editor's interface.
##
## [EditorInterface] gives you control over Godot editor's window. It allows customizing the window, saving and (re-)loading scenes, rendering mesh previews, inspecting and editing resources and objects, and provides access to [EditorSettings], [EditorFileSystem], [EditorResourcePreview], [ScriptEditor], the editor viewport, and information about scenes.
## [b]Note:[/b] This class shouldn't be instantiated directly. Instead, access the singleton directly by its name.
## [codeblocks]
## [gdscript]
## var editor_settings = EditorInterface.get_editor_settings()
## [/gdscript]
## [csharp]
## // In C# you can access it via the static Singleton property.
## EditorSettings settings = EditorInterface.Singleton.GetEditorSettings();
## [/csharp]
## [/codeblocks]



## If [code]true[/code], enables distraction-free mode which hides side docks to increase the space available for the main view.
var distraction_free_mode: bool:
	get = is_distraction_free_mode_enabled, set = set_distraction_free_mode

## If [code]true[/code], the Movie Maker mode is enabled in the editor. See [MovieWriter] for more information.
var movie_maker_enabled: bool:
	get = is_movie_maker_enabled, set = set_movie_maker_enabled



## Edits the given [Node]. The node will be also selected if it's inside the scene tree.
func edit_node(node: Node) -> void:
	pass;

## Edits the given [Resource]. If the resource is a [Script] you can also edit it with [method edit_script] to specify the line and column position.
func edit_resource(resource: Resource) -> void:
	pass;

## Edits the given [Script]. The line and column on which to open the script can also be specified. The script will be open with the user-configured editor for the script's language which may be an external editor.
func edit_script(script: Script, line: int = -1, column: int = 0, grab_focus: bool = true) -> void:
	pass;

## Returns the main container of Godot editor's window. For example, you can use it to retrieve the size of the container and place your controls accordingly.
## [b]Warning:[/b] Removing and freeing this node will render the editor useless and may cause a crash.
func get_base_control() -> Control:
	pass;

## Returns the editor's [EditorCommandPalette] instance.
## [b]Warning:[/b] Removing and freeing this node will render a part of the editor useless and may cause a crash.
func get_command_palette() -> EditorCommandPalette:
	pass;

## Returns the current directory being viewed in the [FileSystemDock]. If a file is selected, its base directory will be returned using [method String.get_base_dir] instead.
func get_current_directory() -> String:
	pass;

## Returns the name of the currently activated feature profile. If the default profile is currently active, an empty string is returned instead.
## In order to get a reference to the [EditorFeatureProfile], you must load the feature profile using [method EditorFeatureProfile.load_from_file].
## [b]Note:[/b] Feature profiles created via the user interface are loaded from the [code]feature_profiles[/code] directory, as a file with the [code].profile[/code] extension. The editor configuration folder can be found by using [method EditorPaths.get_config_dir].
func get_current_feature_profile() -> String:
	pass;

## Returns the current path being viewed in the [FileSystemDock].
func get_current_path() -> String:
	pass;

## Returns the edited (current) scene's root [Node].
func get_edited_scene_root() -> Node:
	pass;

## Returns the editor control responsible for main screen plugins and tools. Use it with plugins that implement [method EditorPlugin._has_main_screen].
## [b]Note:[/b] This node is a [VBoxContainer], which means that if you add a [Control] child to it, you need to set the child's [member Control.size_flags_vertical] to [constant Control.SIZE_EXPAND_FILL] to make it use the full available space.
## [b]Warning:[/b] Removing and freeing this node will render a part of the editor useless and may cause a crash.
func get_editor_main_screen() -> VBoxContainer:
	pass;

## Returns the [EditorPaths] singleton.
func get_editor_paths() -> EditorPaths:
	pass;

## Returns the actual scale of the editor UI ([code]1.0[/code] being 100% scale). This can be used to adjust position and dimensions of the UI added by plugins.
## [b]Note:[/b] This value is set via the [code]interface/editor/display_scale[/code] and [code]interface/editor/custom_display_scale[/code] editor settings. Editor must be restarted for changes to be properly applied.
func get_editor_scale() -> float:
	pass;

## Returns the editor's [EditorSettings] instance.
func get_editor_settings() -> EditorSettings:
	pass;

## Returns the editor's [Theme].
## [b]Note:[/b] When creating custom editor UI, prefer accessing theme items directly from your GUI nodes using the [code]get_theme_*[/code] methods.
func get_editor_theme() -> Theme:
	pass;

## Returns the 2D editor [SubViewport]. It does not have a camera. Instead, the view transforms are done directly and can be accessed with [member Viewport.global_canvas_transform].
func get_editor_viewport_2d() -> SubViewport:
	pass;

## Returns the specified 3D editor [SubViewport], from [code]0[/code] to [code]3[/code]. The viewport can be used to access the active editor cameras with [method Viewport.get_camera_3d].
func get_editor_viewport_3d(idx: int = 0) -> SubViewport:
	pass;

## Returns the editor's [FileSystemDock] instance.
## [b]Warning:[/b] Removing and freeing this node will render a part of the editor useless and may cause a crash.
func get_file_system_dock() -> FileSystemDock:
	pass;

## Returns the editor's [EditorInspector] instance.
## [b]Warning:[/b] Removing and freeing this node will render a part of the editor useless and may cause a crash.
func get_inspector() -> EditorInspector:
	pass;

## Returns an [Array] with the file paths of the currently opened scenes.
func get_open_scenes() -> PackedStringArray:
	pass;

## Returns the name of the scene that is being played. If no scene is currently being played, returns an empty string.
func get_playing_scene() -> String:
	pass;

## Returns the editor's [EditorFileSystem] instance.
func get_resource_filesystem() -> EditorFileSystem:
	pass;

## Returns the editor's [EditorResourcePreview] instance.
func get_resource_previewer() -> EditorResourcePreview:
	pass;

## Returns the editor's [ScriptEditor] instance.
## [b]Warning:[/b] Removing and freeing this node will render a part of the editor useless and may cause a crash.
func get_script_editor() -> ScriptEditor:
	pass;

## Returns an array containing the paths of the currently selected files (and directories) in the [FileSystemDock].
func get_selected_paths() -> PackedStringArray:
	pass;

## Returns the editor's [EditorSelection] instance.
func get_selection() -> EditorSelection:
	pass;

## Shows the given property on the given [param object] in the editor's Inspector dock. If [param inspector_only] is [code]true[/code], plugins will not attempt to edit [param object].
func inspect_object(object: Object, for_property: String = "", inspector_only: bool = false) -> void:
	pass;

## Returns [code]true[/code] if multiple window support is enabled in the editor. Multiple window support is enabled if [i]all[/i] of these statements are true:
## - [member EditorSettings.interface/multi_window/enable] is [code]true[/code].
## - [member EditorSettings.interface/editor/single_window_mode] is [code]false[/code].
## - [member Viewport.gui_embed_subwindows] is [code]false[/code]. This is forced to [code]true[/code] on platforms that don't support multiple windows such as Web, or when the [code]--single-window[/code] [url=$DOCS_URL/tutorials/editor/command_line_tutorial.html]command line argument[/url] is used.
func is_multi_window_enabled() -> bool:
	pass;

## Returns [code]true[/code] if a scene is currently being played, [code]false[/code] otherwise. Paused scenes are considered as being played.
func is_playing_scene() -> bool:
	pass;

## Returns [code]true[/code] if the specified [param plugin] is enabled. The plugin name is the same as its directory name.
func is_plugin_enabled(plugin: String) -> bool:
	pass;

## Returns mesh previews rendered at the given size as an [Array] of [Texture2D]s.
func make_mesh_previews(meshes: Array[Mesh], preview_size: int) -> Array[Texture2D]:
	pass;

## Marks the current scene tab as unsaved.
func mark_scene_as_unsaved() -> void:
	pass;

## Opens the scene at the given path.
func open_scene_from_path(scene_filepath: String) -> void:
	pass;

## Plays the currently active scene.
func play_current_scene() -> void:
	pass;

## Plays the scene specified by its filepath.
func play_custom_scene(scene_filepath: String) -> void:
	pass;

## Plays the main scene.
func play_main_scene() -> void:
	pass;

## Pops up the [param dialog] in the editor UI with [method Window.popup_exclusive]. The dialog must have no current parent, otherwise the method fails.
## See also [method Window.set_unparent_when_invisible].
func popup_dialog(dialog: Window, rect: Rect2i = Rect2i(0, 0, 0, 0)) -> void:
	pass;

## Pops up the [param dialog] in the editor UI with [method Window.popup_exclusive_centered]. The dialog must have no current parent, otherwise the method fails.
## See also [method Window.set_unparent_when_invisible].
func popup_dialog_centered(dialog: Window, minsize: Vector2i = Vector2i(0, 0)) -> void:
	pass;

## Pops up the [param dialog] in the editor UI with [method Window.popup_exclusive_centered_clamped]. The dialog must have no current parent, otherwise the method fails.
## See also [method Window.set_unparent_when_invisible].
func popup_dialog_centered_clamped(dialog: Window, minsize: Vector2i = Vector2i(0, 0), fallback_ratio: float = 0.75) -> void:
	pass;

## Pops up the [param dialog] in the editor UI with [method Window.popup_exclusive_centered_ratio]. The dialog must have no current parent, otherwise the method fails.
## See also [method Window.set_unparent_when_invisible].
func popup_dialog_centered_ratio(dialog: Window, ratio: float = 0.8) -> void:
	pass;

## Pops up an editor dialog for selecting a [Node] from the edited scene. The [param callback] must take a single argument of type [NodePath]. It is called on the selected [NodePath] or the empty path [code]^""[/code] if the dialog is canceled. If [param valid_types] is provided, the dialog will only show Nodes that match one of the listed Node types.
## [b]Example:[/b]
## [codeblock]
## func _ready():
## if Engine.is_editor_hint():
## EditorInterface.popup_node_selector(_on_node_selected, ["Button"])
## func _on_node_selected(node_path):
## if node_path.is_empty():
## print("node selection canceled")
## else:
## print("selected ", node_path)
## [/codeblock]
func popup_node_selector(callback: Callable, valid_types: Array[StringName] = []) -> void:
	pass;

## Pops up an editor dialog for selecting properties from [param object]. The [param callback] must take a single argument of type [NodePath]. It is called on the selected property path (see [method NodePath.get_as_property_path]) or the empty path [code]^""[/code] if the dialog is canceled. If [param type_filter] is provided, the dialog will only show properties that match one of the listed [enum Variant.Type] values.
## [b]Example:[/b]
## [codeblock]
## func _ready():
## if Engine.is_editor_hint():
## EditorInterface.popup_property_selector(this, _on_property_selected, [TYPE_INT])
## func _on_property_selected(property_path):
## if property_path.is_empty():
## print("property selection canceled")
## else:
## print("selected ", property_path)
## [/codeblock]
func popup_property_selector(object: Object, callback: Callable, type_filter: PackedInt32Array = PackedInt32Array()) -> void:
	pass;

## Reloads the scene at the given path.
func reload_scene_from_path(scene_filepath: String) -> void:
	pass;

## Restarts the editor. This closes the editor and then opens the same project. If [param save] is [code]true[/code], the project will be saved before restarting.
func restart_editor(save: bool = true) -> void:
	pass;

## Saves all opened scenes in the editor.
func save_all_scenes() -> void:
	pass;

## Saves the currently active scene. Returns either [constant OK] or [constant ERR_CANT_CREATE].
func save_scene() -> int:
	pass;

## Saves the currently active scene as a file at [param path].
func save_scene_as(path: String, with_preview: bool = true) -> void:
	pass;

## Selects the file, with the path provided by [param file], in the FileSystem dock.
func select_file(file: String) -> void:
	pass;

## Selects and activates the specified feature profile with the given [param profile_name]. Set [param profile_name] to an empty string to reset to the default feature profile.
## A feature profile can be created programmatically using the [EditorFeatureProfile] class.
## [b]Note:[/b] The feature profile that gets activated must be located in the [code]feature_profiles[/code] directory, as a file with the [code].profile[/code] extension. If a profile could not be found, an error occurs. The editor configuration folder can be found by using [method EditorPaths.get_config_dir].
func set_current_feature_profile(profile_name: String) -> void:
	pass;

## Sets the editor's current main screen to the one specified in [param name]. [param name] must match the title of the tab in question exactly (e.g. [code]2D[/code], [code]3D[/code], [code skip-lint]Script[/code], or [code]AssetLib[/code] for default tabs).
func set_main_screen_editor(name: String) -> void:
	pass;

## Sets the enabled status of a plugin. The plugin name is the same as its directory name.
func set_plugin_enabled(plugin: String, enabled: bool) -> void:
	pass;

## Stops the scene that is currently playing.
func stop_playing_scene() -> void:
	pass;


func is_distraction_free_mode_enabled() -> bool:
	return distraction_free_mode

func set_distraction_free_mode(value: bool) -> void:
	distraction_free_mode = value

func is_movie_maker_enabled() -> bool:
	return movie_maker_enabled

func set_movie_maker_enabled(value: bool) -> void:
	movie_maker_enabled = value

