extends RefCounted
class_name EditorFeatureProfile

## An editor feature profile which can be used to disable specific features.
##
## An editor feature profile can be used to disable specific features of the Godot editor. When disabled, the features won't appear in the editor, which makes the editor less cluttered. This is useful in education settings to reduce confusion or when working in a team. For example, artists and level designers could use a feature profile that disables the script editor to avoid accidentally making changes to files they aren't supposed to edit.
## To manage editor feature profiles visually, use [b]Editor > Manage Feature Profiles...[/b] at the top of the editor window.


## The 3D editor. If this feature is disabled, the 3D editor won't display but 3D nodes will still display in the Create New Node dialog.
## The Script tab, which contains the script editor and class reference browser. If this feature is disabled, the Script tab won't display.
## The AssetLib tab. If this feature is disabled, the AssetLib tab won't display.
## Scene tree editing. If this feature is disabled, the Scene tree dock will still be visible but will be read-only.
## The Node dock. If this feature is disabled, signals and groups won't be visible and modifiable from the editor.
## The FileSystem dock. If this feature is disabled, the FileSystem dock won't be visible.
## The Import dock. If this feature is disabled, the Import dock won't be visible.
## The History dock. If this feature is disabled, the History dock won't be visible.
## Represents the size of the [enum Feature] enum.

#enum Feature
enum {
    FEATURE_3D = 0,
    FEATURE_SCRIPT = 1,
    FEATURE_ASSET_LIB = 2,
    FEATURE_SCENE_TREE = 3,
    FEATURE_NODE_DOCK = 4,
    FEATURE_FILESYSTEM_DOCK = 5,
    FEATURE_IMPORT_DOCK = 6,
    FEATURE_HISTORY_DOCK = 7,
    FEATURE_MAX = 8,
}


## Returns the specified [param feature]'s human-readable name.
func get_feature_name(feature: int) -> String:
	pass;

## Returns [code]true[/code] if the class specified by [param class_name] is disabled. When disabled, the class won't appear in the Create New Node dialog.
func is_class_disabled(class_name: StringName) -> bool:
	pass;

## Returns [code]true[/code] if editing for the class specified by [param class_name] is disabled. When disabled, the class will still appear in the Create New Node dialog but the Inspector will be read-only when selecting a node that extends the class.
func is_class_editor_disabled(class_name: StringName) -> bool:
	pass;

## Returns [code]true[/code] if [param property] is disabled in the class specified by [param class_name]. When a property is disabled, it won't appear in the Inspector when selecting a node that extends the class specified by [param class_name].
func is_class_property_disabled(class_name: StringName, property: StringName) -> bool:
	pass;

## Returns [code]true[/code] if the [param feature] is disabled. When a feature is disabled, it will disappear from the editor entirely.
func is_feature_disabled(feature: int) -> bool:
	pass;

## Loads an editor feature profile from a file. The file must follow the JSON format obtained by using the feature profile manager's [b]Export[/b] button or the [method save_to_file] method.
## [b]Note:[/b] Feature profiles created via the user interface are loaded from the [code]feature_profiles[/code] directory, as a file with the [code].profile[/code] extension. The editor configuration folder can be found by using [method EditorPaths.get_config_dir].
func load_from_file(path: String) -> int:
	pass;

## Saves the editor feature profile to a file in JSON format. It can then be imported using the feature profile manager's [b]Import[/b] button or the [method load_from_file] method.
## [b]Note:[/b] Feature profiles created via the user interface are saved in the [code]feature_profiles[/code] directory, as a file with the [code].profile[/code] extension. The editor configuration folder can be found by using [method EditorPaths.get_config_dir].
func save_to_file(path: String) -> int:
	pass;

## If [param disable] is [code]true[/code], disables the class specified by [param class_name]. When disabled, the class won't appear in the Create New Node dialog.
func set_disable_class(class_name: StringName, disable: bool) -> void:
	pass;

## If [param disable] is [code]true[/code], disables editing for the class specified by [param class_name]. When disabled, the class will still appear in the Create New Node dialog but the Inspector will be read-only when selecting a node that extends the class.
func set_disable_class_editor(class_name: StringName, disable: bool) -> void:
	pass;

## If [param disable] is [code]true[/code], disables editing for [param property] in the class specified by [param class_name]. When a property is disabled, it won't appear in the Inspector when selecting a node that extends the class specified by [param class_name].
func set_disable_class_property(class_name: StringName, property: StringName, disable: bool) -> void:
	pass;

## If [param disable] is [code]true[/code], disables the editor feature specified in [param feature]. When a feature is disabled, it will disappear from the editor entirely.
func set_disable_feature(feature: int, disable: bool) -> void:
	pass;


