extends Control
class_name Container

## Base class for all GUI containers.
##
## Base class for all GUI containers. A [Container] automatically arranges its child controls in a certain way. This class can be inherited to make custom container types.
##
## @tutorial(Using Containers): https://docs.godotengine.org/en/stable/tutorials/ui/gui_containers.html


## Emitted when children are going to be sorted.
signal pre_sort_children
## Emitted when sorting the children is needed.
signal sort_children
## Notification just before children are going to be sorted, in case there's something to process beforehand.
const NOTIFICATION_PRE_SORT_CHILDREN = 50;

## Notification for when sorting the children, it must be obeyed immediately.
const NOTIFICATION_SORT_CHILDREN = 51;


var mouse_filter: int:
	get = get_mouse_filter, set = set_mouse_filter



## Implement to return a list of allowed horizontal [enum Control.SizeFlags] for child nodes. This doesn't technically prevent the usages of any other size flags, if your implementation requires that. This only limits the options available to the user in the Inspector dock.
## [b]Note:[/b] Having no size flags is equal to having [constant Control.SIZE_SHRINK_BEGIN]. As such, this value is always implicitly allowed.
func _get_allowed_size_flags_horizontal() -> PackedInt32Array:
	pass;

## Implement to return a list of allowed vertical [enum Control.SizeFlags] for child nodes. This doesn't technically prevent the usages of any other size flags, if your implementation requires that. This only limits the options available to the user in the Inspector dock.
## [b]Note:[/b] Having no size flags is equal to having [constant Control.SIZE_SHRINK_BEGIN]. As such, this value is always implicitly allowed.
func _get_allowed_size_flags_vertical() -> PackedInt32Array:
	pass;

## Fit a child control in a given rect. This is mainly a helper for creating custom container classes.
func fit_child_in_rect(child: Control, rect: Rect2) -> void:
	pass;

## Queue resort of the contained children. This is called automatically anyway, but can be called upon request.
func queue_sort() -> void:
	pass;


func get_mouse_filter() -> int:
	return mouse_filter

func set_mouse_filter(value: int) -> void:
	mouse_filter = value

