extends AudioStream
class_name AudioStreamSynchronized

## Stream that can be fitted with sub-streams, which will be played in-sync.
##
## This is a stream that can be fitted with sub-streams, which will be played in-sync. The streams being at exactly the same time when play is pressed, and will end when the last of them ends. If one of the sub-streams loops, then playback will continue.


## Maximum amount of streams that can be synchronized.
const MAX_STREAMS = 32;


## Set the total amount of streams that will be played back synchronized.
var stream_count: int:
	get = get_stream_count, set = set_stream_count



## Get one of the synchronized streams, by index.
func get_sync_stream(stream_index: int) -> AudioStream:
	pass;

## Get the volume of one of the synchronized streams, by index.
func get_sync_stream_volume(stream_index: int) -> float:
	pass;

## Set one of the synchronized streams, by index.
func set_sync_stream(stream_index: int, audio_stream: AudioStream) -> void:
	pass;

## Set the volume of one of the synchronized streams, by index.
func set_sync_stream_volume(stream_index: int, volume_db: float) -> void:
	pass;


func get_stream_count() -> int:
	return stream_count

func set_stream_count(value: int) -> void:
	stream_count = value

