extends RefCounted
class_name AudioStreamPlayback

## Meta class for playing back audio.
##
## Can play, loop, pause a scroll through audio. See [AudioStream] and [AudioStreamOggVorbis] for usage.
##
## @tutorial(Audio Generator Demo): https://godotengine.org/asset-library/asset/2759





## Overridable method. Should return how many times this audio stream has looped. Most built-in playbacks always return [code]0[/code].
func _get_loop_count() -> int:
	pass;

## Return the current value of a playback parameter by name (see [method AudioStream._get_parameter_list]).
func _get_parameter(name: StringName) -> Variant:
	pass;

## Overridable method. Should return the current progress along the audio stream, in seconds.
func _get_playback_position() -> float:
	pass;

## Overridable method. Should return [code]true[/code] if this playback is active and playing its audio stream.
func _is_playing() -> bool:
	pass;

## Override this method to customize how the audio stream is mixed. This method is called even if the playback is not active.
## [b]Note:[/b] It is not useful to override this method in GDScript or C#. Only GDExtension can take advantage of it.
func _mix(buffer: AudioFrame*, rate_scale: float, frames: int) -> int:
	pass;

## Override this method to customize what happens when seeking this audio stream at the given [param position], such as by calling [method AudioStreamPlayer.seek].
func _seek(position: float) -> void:
	pass;

## Set the current value of a playback parameter by name (see [method AudioStream._get_parameter_list]).
func _set_parameter(name: StringName, value: Variant) -> void:
	pass;

## Override this method to customize what happens when the playback starts at the given position, such as by calling [method AudioStreamPlayer.play].
func _start(from_pos: float) -> void:
	pass;

## Override this method to customize what happens when the playback is stopped, such as by calling [method AudioStreamPlayer.stop].
func _stop() -> void:
	pass;

## Overridable method. Called whenever the audio stream is mixed if the playback is active and [method AudioServer.set_enable_tagging_used_audio_streams] has been set to [code]true[/code]. Editor plugins may use this method to "tag" the current position along the audio stream and display it in a preview.
func _tag_used_streams() -> void:
	pass;

## Returns the [AudioSamplePlayback] associated with this [AudioStreamPlayback] for playing back the audio sample of this stream.
func get_sample_playback() -> AudioSamplePlayback:
	pass;

## Associates [AudioSamplePlayback] to this [AudioStreamPlayback] for playing back the audio sample of this stream.
func set_sample_playback(playback_sample: AudioSamplePlayback) -> void:
	pass;


