extends AnimationNodeSync
class_name AnimationNodeBlend2

## Blends two animations linearly inside of an [AnimationNodeBlendTree].
##
## A resource to add to an [AnimationNodeBlendTree]. Blends two animations linearly based on the amount value.
## In general, the blend value should be in the [code][0.0, 1.0][/code] range. Values outside of this range can blend amplified or inverted animations, however, [AnimationNodeAdd2] works better for this purpose.
##
## @tutorial(Using AnimationTree): https://docs.godotengine.org/en/stable/tutorials/animation/animation_tree.html
## @tutorial(3D Platformer Demo): https://godotengine.org/asset-library/asset/2748
## @tutorial(Third Person Shooter (TPS) Demo): https://godotengine.org/asset-library/asset/2710






