extends AnimationNodeSync
class_name AnimationNodeAdd2

## Blends two animations additively inside of an [AnimationNodeBlendTree].
##
## A resource to add to an [AnimationNodeBlendTree]. Blends two animations additively based on the amount value.
## If the amount is greater than [code]1.0[/code], the animation connected to "in" port is blended with the amplified animation connected to "add" port.
## If the amount is less than [code]0.0[/code], the animation connected to "in" port is blended with the inverted animation connected to "add" port.
##
## @tutorial(Using AnimationTree): https://docs.godotengine.org/en/stable/tutorials/animation/animation_tree.html






