extends VisualShaderNode
class_name VisualShaderNodeTransformOp

## A [Transform3D] operator to be used within the visual shader graph.
##
## Applies [member operator] to two transform (4x4 matrices) inputs.


## Multiplies transform [code]a[/code] by the transform [code]b[/code].
## Multiplies transform [code]b[/code] by the transform [code]a[/code].
## Performs a component-wise multiplication of transform [code]a[/code] by the transform [code]b[/code].
## Performs a component-wise multiplication of transform [code]b[/code] by the transform [code]a[/code].
## Adds two transforms.
## Subtracts the transform [code]a[/code] from the transform [code]b[/code].
## Subtracts the transform [code]b[/code] from the transform [code]a[/code].
## Divides the transform [code]a[/code] by the transform [code]b[/code].
## Divides the transform [code]b[/code] by the transform [code]a[/code].
## Represents the size of the [enum Operator] enum.

#enum Operator
enum {
    OP_AxB = 0,
    OP_BxA = 1,
    OP_AxB_COMP = 2,
    OP_BxA_COMP = 3,
    OP_ADD = 4,
    OP_A_MINUS_B = 5,
    OP_B_MINUS_A = 6,
    OP_A_DIV_B = 7,
    OP_B_DIV_A = 8,
    OP_MAX = 9,
}
## The type of the operation to be performed on the transforms. See [enum Operator] for options.
var operator: int:
	get = get_operator, set = set_operator




func get_operator() -> int:
	return operator

func set_operator(value: int) -> void:
	operator = value

