extends Resource
class_name VisualShaderNode

## Base class for [VisualShader] nodes. Not related to scene nodes.
##
## Visual shader graphs consist of various nodes. Each node in the graph is a separate object and they are represented as a rectangular boxes with title and a set of properties. Each node also has connection ports that allow to connect it to another nodes and control the flow of the shader.
##
## @tutorial(Using VisualShaders): https://docs.godotengine.org/en/stable/tutorials/shaders/visual_shaders.html


## Floating-point scalar. Translated to [code skip-lint]float[/code] type in shader code.
## Integer scalar. Translated to [code skip-lint]int[/code] type in shader code.
## Unsigned integer scalar. Translated to [code skip-lint]uint[/code] type in shader code.
## 2D vector of floating-point values. Translated to [code skip-lint]vec2[/code] type in shader code.
## 3D vector of floating-point values. Translated to [code skip-lint]vec3[/code] type in shader code.
## 4D vector of floating-point values. Translated to [code skip-lint]vec4[/code] type in shader code.
## Boolean type. Translated to [code skip-lint]bool[/code] type in shader code.
## Transform type. Translated to [code skip-lint]mat4[/code] type in shader code.
## Sampler type. Translated to reference of sampler uniform in shader code. Can only be used for input ports in non-uniform nodes.
## Represents the size of the [enum PortType] enum.

#enum PortType
enum {
    PORT_TYPE_SCALAR = 0,
    PORT_TYPE_SCALAR_INT = 1,
    PORT_TYPE_SCALAR_UINT = 2,
    PORT_TYPE_VECTOR_2D = 3,
    PORT_TYPE_VECTOR_3D = 4,
    PORT_TYPE_VECTOR_4D = 5,
    PORT_TYPE_BOOLEAN = 6,
    PORT_TYPE_TRANSFORM = 7,
    PORT_TYPE_SAMPLER = 8,
    PORT_TYPE_MAX = 9,
}
## Sets the output port index which will be showed for preview. If set to [code]-1[/code] no port will be open for preview.
var output_port_for_preview: int:
	get = get_output_port_for_preview, set = set_output_port_for_preview



## Clears the default input ports value.
func clear_default_input_values() -> void:
	pass;

## Returns the input port which should be connected by default when this node is created as a result of dragging a connection from an existing node to the empty space on the graph.
func get_default_input_port(type: int) -> int:
	pass;

## Returns an [Array] containing default values for all of the input ports of the node in the form [code][index0, value0, index1, value1, ...][/code].
func get_default_input_values() -> Array:
	pass;

## Returns the default value of the input [param port].
func get_input_port_default_value(port: int) -> Variant:
	pass;

## Removes the default value of the input [param port].
func remove_input_port_default_value(port: int) -> void:
	pass;

## Sets the default input ports values using an [Array] of the form [code][index0, value0, index1, value1, ...][/code]. For example: [code][0, Vector3(0, 0, 0), 1, Vector3(0, 0, 0)][/code].
func set_default_input_values(values: Array) -> void:
	pass;

## Sets the default [param value] for the selected input [param port].
func set_input_port_default_value(port: int, value: Variant, prev_value: Variant = null) -> void:
	pass;


func get_output_port_for_preview() -> int:
	return output_port_for_preview

func set_output_port_for_preview(value: int) -> void:
	output_port_for_preview = value

