extends VisibleOnScreenNotifier3D
class_name VisibleOnScreenEnabler3D

## A box-shaped region of 3D space that, when visible on screen, enables a target node.
##
## [VisibleOnScreenEnabler3D] contains a box-shaped region of 3D space and a target node. The target node will be automatically enabled (via its [member Node.process_mode] property) when any part of this region becomes visible on the screen, and automatically disabled otherwise. This can for example be used to activate enemies only when the player approaches them.
## See [VisibleOnScreenNotifier3D] if you only want to be notified when the region is visible on screen.
## [b]Note:[/b] [VisibleOnScreenEnabler3D] uses an approximate heuristic that doesn't take walls and other occlusion into account, unless occlusion culling is used. It also won't function unless [member Node3D.visible] is set to [code]true[/code].


## Corresponds to [constant Node.PROCESS_MODE_INHERIT].
## Corresponds to [constant Node.PROCESS_MODE_ALWAYS].
## Corresponds to [constant Node.PROCESS_MODE_WHEN_PAUSED].

#enum EnableMode
enum {
    ENABLE_MODE_INHERIT = 0,
    ENABLE_MODE_ALWAYS = 1,
    ENABLE_MODE_WHEN_PAUSED = 2,
}
## Determines how the target node is enabled. Corresponds to [enum Node.ProcessMode]. When the node is disabled, it always uses [constant Node.PROCESS_MODE_DISABLED].
var enable_mode: int:
	get = get_enable_mode, set = set_enable_mode

## The path to the target node, relative to the [VisibleOnScreenEnabler3D]. The target node is cached; it's only assigned when setting this property (if the [VisibleOnScreenEnabler3D] is inside the scene tree) and every time the [VisibleOnScreenEnabler3D] enters the scene tree. If the path is invalid, an error will be printed in the editor and no node will be affected.
var enable_node_path: NodePath:
	get = get_enable_node_path, set = set_enable_node_path




func get_enable_mode() -> int:
	return enable_mode

func set_enable_mode(value: int) -> void:
	enable_mode = value

func get_enable_node_path() -> NodePath:
	return enable_node_path

func set_enable_node_path(value: NodePath) -> void:
	enable_node_path = value

