class_name Transform2D

## A 2×3 matrix representing a 2D transformation.
##
## A 2×3 matrix (2 rows, 3 columns) used for 2D linear transformations. It can represent transformations such as translation, rotation, and scaling. It consists of three [Vector2] values: [member x], [member y], and the [member origin].
## For more information, read the "Matrices and transforms" documentation article.
##
## @tutorial(Math documentation index): https://docs.godotengine.org/en/stable/tutorials/math/index.html
## @tutorial(Matrices and transforms): https://docs.godotengine.org/en/stable/tutorials/math/matrices_and_transforms.html
## @tutorial(Matrix Transform Demo): https://godotengine.org/asset-library/asset/584
## @tutorial(2.5D Demo): https://godotengine.org/asset-library/asset/583


## The identity [Transform2D] with no translation, rotation or scaling applied. When applied to other data structures, [constant IDENTITY] performs no transformation.
const IDENTITY = Transform2D(1, 0, 0, 1, 0, 0);

## The [Transform2D] that will flip something along the X axis.
const FLIP_X = Transform2D(-1, 0, 0, 1, 0, 0);

## The [Transform2D] that will flip something along the Y axis.
const FLIP_Y = Transform2D(1, 0, 0, -1, 0, 0);


## The origin vector (column 2, the third column). Equivalent to array index [code]2[/code]. The origin vector represents translation.
var origin: Vector2

## The basis matrix's X vector (column 0). Equivalent to array index [code]0[/code].
var x: Vector2

## The basis matrix's Y vector (column 1). Equivalent to array index [code]1[/code].
var y: Vector2


## Constructs a default-initialized [Transform2D] set to [constant IDENTITY].
func Transform2D() -> Transform2D:
	pass;

## Constructs a [Transform2D] as a copy of the given [Transform2D].
func Transform2D(from: Transform2D) -> Transform2D:
	pass;

## Constructs the transform from a given angle (in radians) and position.
func Transform2D(rotation: float, position: Vector2) -> Transform2D:
	pass;

## Constructs the transform from a given angle (in radians), scale, skew (in radians) and position.
func Transform2D(rotation: float, scale: Vector2, skew: float, position: Vector2) -> Transform2D:
	pass;

## Constructs the transform from 3 [Vector2] values representing [member x], [member y], and the [member origin] (the three column vectors).
func Transform2D(x_axis: Vector2, y_axis: Vector2, origin: Vector2) -> Transform2D:
	pass;


## Returns the inverse of the transform, under the assumption that the basis is invertible (must have non-zero determinant).
func affine_inverse() -> Transform2D:
	pass;

## Returns a vector transformed (multiplied) by the basis matrix.
## This method does not account for translation (the [member origin] vector).
func basis_xform(v: Vector2) -> Vector2:
	pass;

## Returns a vector transformed (multiplied) by the inverse basis matrix, under the assumption that the basis is orthonormal (i.e. rotation/reflection is fine, scaling/skew is not).
## This method does not account for translation (the [member origin] vector).
## [code]transform.basis_xform_inv(vector)[/code] is equivalent to [code]transform.inverse().basis_xform(vector)[/code]. See [method inverse].
## For non-orthonormal transforms (e.g. with scaling) [code]transform.affine_inverse().basis_xform(vector)[/code] can be used instead. See [method affine_inverse].
func basis_xform_inv(v: Vector2) -> Vector2:
	pass;

## Returns the determinant of the basis matrix. If the basis is uniformly scaled, then its determinant equals the square of the scale factor.
## A negative determinant means the basis was flipped, so one part of the scale is negative. A zero determinant means the basis isn't invertible, and is usually considered invalid.
func determinant() -> float:
	pass;

## Returns the transform's origin (translation).
func get_origin() -> Vector2:
	pass;

## Returns the transform's rotation (in radians).
func get_rotation() -> float:
	pass;

## Returns the scale.
func get_scale() -> Vector2:
	pass;

## Returns the transform's skew (in radians).
func get_skew() -> float:
	pass;

## Returns a transform interpolated between this transform and another by a given [param weight] (on the range of 0.0 to 1.0).
func interpolate_with(xform: Transform2D, weight: float) -> Transform2D:
	pass;

## Returns the inverse of the transform, under the assumption that the transformation basis is orthonormal (i.e. rotation/reflection is fine, scaling/skew is not). Use [method affine_inverse] for non-orthonormal transforms (e.g. with scaling).
func inverse() -> Transform2D:
	pass;

## Returns [code]true[/code] if the transform's basis is conformal, meaning it preserves angles and distance ratios, and may only be composed of rotation and uniform scale. Returns [code]false[/code] if the transform's basis has non-uniform scale or shear/skew. This can be used to validate if the transform is non-distorted, which is important for physics and other use cases.
func is_conformal() -> bool:
	pass;

## Returns [code]true[/code] if this transform and [param xform] are approximately equal, by running [method @GlobalScope.is_equal_approx] on each component.
func is_equal_approx(xform: Transform2D) -> bool:
	pass;

## Returns [code]true[/code] if this transform is finite, by calling [method @GlobalScope.is_finite] on each component.
func is_finite() -> bool:
	pass;

## Returns a copy of the transform rotated such that the rotated X-axis points towards the [param target] position.
## Operations take place in global space.
func looking_at(target: Vector2 = Vector2(0, 0)) -> Transform2D:
	pass;

## Returns the transform with the basis orthogonal (90 degrees), and normalized axis vectors (scale of 1 or -1).
func orthonormalized() -> Transform2D:
	pass;

## Returns a copy of the transform rotated by the given [param angle] (in radians).
## This method is an optimized version of multiplying the given transform [code]X[/code] with a corresponding rotation transform [code]R[/code] from the left, i.e., [code]R * X[/code].
## This can be seen as transforming with respect to the global/parent frame.
func rotated(angle: float) -> Transform2D:
	pass;

## Returns a copy of the transform rotated by the given [param angle] (in radians).
## This method is an optimized version of multiplying the given transform [code]X[/code] with a corresponding rotation transform [code]R[/code] from the right, i.e., [code]X * R[/code].
## This can be seen as transforming with respect to the local frame.
func rotated_local(angle: float) -> Transform2D:
	pass;

## Returns a copy of the transform scaled by the given [param scale] factor.
## This method is an optimized version of multiplying the given transform [code]X[/code] with a corresponding scaling transform [code]S[/code] from the left, i.e., [code]S * X[/code].
## This can be seen as transforming with respect to the global/parent frame.
func scaled(scale: Vector2) -> Transform2D:
	pass;

## Returns a copy of the transform scaled by the given [param scale] factor.
## This method is an optimized version of multiplying the given transform [code]X[/code] with a corresponding scaling transform [code]S[/code] from the right, i.e., [code]X * S[/code].
## This can be seen as transforming with respect to the local frame.
func scaled_local(scale: Vector2) -> Transform2D:
	pass;

## Returns a copy of the transform translated by the given [param offset].
## This method is an optimized version of multiplying the given transform [code]X[/code] with a corresponding translation transform [code]T[/code] from the left, i.e., [code]T * X[/code].
## This can be seen as transforming with respect to the global/parent frame.
func translated(offset: Vector2) -> Transform2D:
	pass;

## Returns a copy of the transform translated by the given [param offset].
## This method is an optimized version of multiplying the given transform [code]X[/code] with a corresponding translation transform [code]T[/code] from the right, i.e., [code]X * T[/code].
## This can be seen as transforming with respect to the local frame.
func translated_local(offset: Vector2) -> Transform2D:
	pass;


