extends Object
class_name Time

## A singleton for working with time data.
##
## The Time singleton allows converting time between various formats and also getting time information from the system.
## This class conforms with as many of the ISO 8601 standards as possible. All dates follow the Proleptic Gregorian calendar. As such, the day before [code]1582-10-15[/code] is [code]1582-10-14[/code], not [code]1582-10-04[/code]. The year before 1 AD (aka 1 BC) is number [code]0[/code], with the year before that (2 BC) being [code]-1[/code], etc.
## Conversion methods assume "the same timezone", and do not handle timezone conversions or DST automatically. Leap seconds are also not handled, they must be done manually if desired. Suffixes such as "Z" are not handled, you need to strip them away manually.
## When getting time information from the system, the time can either be in the local timezone or UTC depending on the [code]utc[/code] parameter. However, the [method get_unix_time_from_system] method always returns the time in UTC.
## [b]Important:[/b] The [code]_from_system[/code] methods use the system clock that the user can manually set. [b]Never use[/b] this method for precise time calculation since its results are subject to automatic adjustments by the user or the operating system. [b]Always use[/b] [method get_ticks_usec] or [method get_ticks_msec] for precise time calculation instead, since they are guaranteed to be monotonic (i.e. never decrease).


## The month of January, represented numerically as [code]01[/code].
## The month of February, represented numerically as [code]02[/code].
## The month of March, represented numerically as [code]03[/code].
## The month of April, represented numerically as [code]04[/code].
## The month of May, represented numerically as [code]05[/code].
## The month of June, represented numerically as [code]06[/code].
## The month of July, represented numerically as [code]07[/code].
## The month of August, represented numerically as [code]08[/code].
## The month of September, represented numerically as [code]09[/code].
## The month of October, represented numerically as [code]10[/code].
## The month of November, represented numerically as [code]11[/code].
## The month of December, represented numerically as [code]12[/code].
## The day of the week Sunday, represented numerically as [code]0[/code].
## The day of the week Monday, represented numerically as [code]1[/code].
## The day of the week Tuesday, represented numerically as [code]2[/code].
## The day of the week Wednesday, represented numerically as [code]3[/code].
## The day of the week Thursday, represented numerically as [code]4[/code].
## The day of the week Friday, represented numerically as [code]5[/code].
## The day of the week Saturday, represented numerically as [code]6[/code].

#enum Month
enum {
    MONTH_JANUARY = 1,
    MONTH_FEBRUARY = 2,
    MONTH_MARCH = 3,
    MONTH_APRIL = 4,
    MONTH_MAY = 5,
    MONTH_JUNE = 6,
    MONTH_JULY = 7,
    MONTH_AUGUST = 8,
    MONTH_SEPTEMBER = 9,
    MONTH_OCTOBER = 10,
    MONTH_NOVEMBER = 11,
    MONTH_DECEMBER = 12,
}
#enum Weekday
enum {
    WEEKDAY_SUNDAY = 0,
    WEEKDAY_MONDAY = 1,
    WEEKDAY_TUESDAY = 2,
    WEEKDAY_WEDNESDAY = 3,
    WEEKDAY_THURSDAY = 4,
    WEEKDAY_FRIDAY = 5,
    WEEKDAY_SATURDAY = 6,
}


## Returns the current date as a dictionary of keys: [code]year[/code], [code]month[/code], [code]day[/code], and [code]weekday[/code].
## The returned values are in the system's local time when [param utc] is [code]false[/code], otherwise they are in UTC.
func get_date_dict_from_system(utc: bool = false) -> Dictionary:
	pass;

## Converts the given Unix timestamp to a dictionary of keys: [code]year[/code], [code]month[/code], [code]day[/code], and [code]weekday[/code].
func get_date_dict_from_unix_time(unix_time_val: int) -> Dictionary:
	pass;

## Returns the current date as an ISO 8601 date string (YYYY-MM-DD).
## The returned values are in the system's local time when [param utc] is [code]false[/code], otherwise they are in UTC.
func get_date_string_from_system(utc: bool = false) -> String:
	pass;

## Converts the given Unix timestamp to an ISO 8601 date string (YYYY-MM-DD).
func get_date_string_from_unix_time(unix_time_val: int) -> String:
	pass;

## Converts the given ISO 8601 date and time string (YYYY-MM-DDTHH:MM:SS) to a dictionary of keys: [code]year[/code], [code]month[/code], [code]day[/code], [code skip-lint]weekday[/code], [code]hour[/code], [code]minute[/code], and [code]second[/code].
## If [param weekday] is [code]false[/code], then the [code skip-lint]weekday[/code] entry is excluded (the calculation is relatively expensive).
## [b]Note:[/b] Any decimal fraction in the time string will be ignored silently.
func get_datetime_dict_from_datetime_string(datetime: String, weekday: bool) -> Dictionary:
	pass;

## Returns the current date as a dictionary of keys: [code]year[/code], [code]month[/code], [code]day[/code], [code]weekday[/code], [code]hour[/code], [code]minute[/code], [code]second[/code], and [code]dst[/code] (Daylight Savings Time).
func get_datetime_dict_from_system(utc: bool = false) -> Dictionary:
	pass;

## Converts the given Unix timestamp to a dictionary of keys: [code]year[/code], [code]month[/code], [code]day[/code], [code]weekday[/code], [code]hour[/code], [code]minute[/code], and [code]second[/code].
## The returned Dictionary's values will be the same as the [method get_datetime_dict_from_system] if the Unix timestamp is the current time, with the exception of Daylight Savings Time as it cannot be determined from the epoch.
func get_datetime_dict_from_unix_time(unix_time_val: int) -> Dictionary:
	pass;

## Converts the given dictionary of keys to an ISO 8601 date and time string (YYYY-MM-DDTHH:MM:SS).
## The given dictionary can be populated with the following keys: [code]year[/code], [code]month[/code], [code]day[/code], [code]hour[/code], [code]minute[/code], and [code]second[/code]. Any other entries (including [code]dst[/code]) are ignored.
## If the dictionary is empty, [code]0[/code] is returned. If some keys are omitted, they default to the equivalent values for the Unix epoch timestamp 0 (1970-01-01 at 00:00:00).
## If [param use_space] is [code]true[/code], the date and time bits are separated by an empty space character instead of the letter T.
func get_datetime_string_from_datetime_dict(datetime: Dictionary, use_space: bool) -> String:
	pass;

## Returns the current date and time as an ISO 8601 date and time string (YYYY-MM-DDTHH:MM:SS).
## The returned values are in the system's local time when [param utc] is [code]false[/code], otherwise they are in UTC.
## If [param use_space] is [code]true[/code], the date and time bits are separated by an empty space character instead of the letter T.
func get_datetime_string_from_system(utc: bool = false, use_space: bool = false) -> String:
	pass;

## Converts the given Unix timestamp to an ISO 8601 date and time string (YYYY-MM-DDTHH:MM:SS).
## If [param use_space] is [code]true[/code], the date and time bits are separated by an empty space character instead of the letter T.
func get_datetime_string_from_unix_time(unix_time_val: int, use_space: bool = false) -> String:
	pass;

## Converts the given timezone offset in minutes to a timezone offset string. For example, -480 returns "-08:00", 345 returns "+05:45", and 0 returns "+00:00".
func get_offset_string_from_offset_minutes(offset_minutes: int) -> String:
	pass;

## Returns the amount of time passed in milliseconds since the engine started.
## Will always be positive or 0 and uses a 64-bit value (it will wrap after roughly 500 million years).
func get_ticks_msec() -> int:
	pass;

## Returns the amount of time passed in microseconds since the engine started.
## Will always be positive or 0 and uses a 64-bit value (it will wrap after roughly half a million years).
func get_ticks_usec() -> int:
	pass;

## Returns the current time as a dictionary of keys: [code]hour[/code], [code]minute[/code], and [code]second[/code].
## The returned values are in the system's local time when [param utc] is [code]false[/code], otherwise they are in UTC.
func get_time_dict_from_system(utc: bool = false) -> Dictionary:
	pass;

## Converts the given time to a dictionary of keys: [code]hour[/code], [code]minute[/code], and [code]second[/code].
func get_time_dict_from_unix_time(unix_time_val: int) -> Dictionary:
	pass;

## Returns the current time as an ISO 8601 time string (HH:MM:SS).
## The returned values are in the system's local time when [param utc] is [code]false[/code], otherwise they are in UTC.
func get_time_string_from_system(utc: bool = false) -> String:
	pass;

## Converts the given Unix timestamp to an ISO 8601 time string (HH:MM:SS).
func get_time_string_from_unix_time(unix_time_val: int) -> String:
	pass;

## Returns the current time zone as a dictionary of keys: [code]bias[/code] and [code]name[/code].
## - [code]bias[/code] is the offset from UTC in minutes, since not all time zones are multiples of an hour from UTC.
## - [code]name[/code] is the localized name of the time zone, according to the OS locale settings of the current user.
func get_time_zone_from_system() -> Dictionary:
	pass;

## Converts a dictionary of time values to a Unix timestamp.
## The given dictionary can be populated with the following keys: [code]year[/code], [code]month[/code], [code]day[/code], [code]hour[/code], [code]minute[/code], and [code]second[/code]. Any other entries (including [code]dst[/code]) are ignored.
## If the dictionary is empty, [code]0[/code] is returned. If some keys are omitted, they default to the equivalent values for the Unix epoch timestamp 0 (1970-01-01 at 00:00:00).
## You can pass the output from [method get_datetime_dict_from_unix_time] directly into this function and get the same as what was put in.
## [b]Note:[/b] Unix timestamps are often in UTC. This method does not do any timezone conversion, so the timestamp will be in the same timezone as the given datetime dictionary.
func get_unix_time_from_datetime_dict(datetime: Dictionary) -> int:
	pass;

## Converts the given ISO 8601 date and/or time string to a Unix timestamp. The string can contain a date only, a time only, or both.
## [b]Note:[/b] Unix timestamps are often in UTC. This method does not do any timezone conversion, so the timestamp will be in the same timezone as the given datetime string.
## [b]Note:[/b] Any decimal fraction in the time string will be ignored silently.
func get_unix_time_from_datetime_string(datetime: String) -> int:
	pass;

## Returns the current Unix timestamp in seconds based on the system time in UTC. This method is implemented by the operating system and always returns the time in UTC.
## [b]Note:[/b] Unlike other methods that use integer timestamps, this method returns the timestamp as a [float] for sub-second precision.
func get_unix_time_from_system() -> float:
	pass;


