extends Resource
class_name TileSetSource

## Exposes a set of tiles for a [TileSet] resource.
##
## Exposes a set of tiles for a [TileSet] resource.
## Tiles in a source are indexed with two IDs, coordinates ID (of type Vector2i) and an alternative ID (of type int), named according to their use in the [TileSetAtlasSource] class.
## Depending on the TileSet source type, those IDs might have restrictions on their values, this is why the base [TileSetSource] class only exposes getters for them.
## You can iterate over all tiles exposed by a TileSetSource by first iterating over coordinates IDs using [method get_tiles_count] and [method get_tile_id], then over alternative IDs using [method get_alternative_tiles_count] and [method get_alternative_tile_id].
## [b]Warning:[/b] [TileSetSource] can only be added to one TileSet at the same time. Calling [method TileSet.add_source] on a second [TileSet] will remove the source from the first one.





## Returns the alternative ID for the tile with coordinates ID [param atlas_coords] at index [param index].
func get_alternative_tile_id(atlas_coords: Vector2i, index: int) -> int:
	pass;

## Returns the number of alternatives tiles for the coordinates ID [param atlas_coords].
## For [TileSetAtlasSource], this always return at least 1, as the base tile with ID 0 is always part of the alternatives list.
## Returns -1 if there is not tile at the given coords.
func get_alternative_tiles_count(atlas_coords: Vector2i) -> int:
	pass;

## Returns the tile coordinates ID of the tile with index [param index].
func get_tile_id(index: int) -> Vector2i:
	pass;

## Returns how many tiles this atlas source defines (not including alternative tiles).
func get_tiles_count() -> int:
	pass;

## Returns if the base tile at coordinates [param atlas_coords] has an alternative with ID [param alternative_tile].
func has_alternative_tile(atlas_coords: Vector2i, alternative_tile: int) -> bool:
	pass;

## Returns if this atlas has a tile with coordinates ID [param atlas_coords].
func has_tile(atlas_coords: Vector2i) -> bool:
	pass;


