extends Resource
class_name Shape3D

## Abstract base class for 3D shapes used for physics collision.
##
## Abstract base class for all 3D shapes, intended for use in physics.
## [b]Performance:[/b] Primitive shapes, especially [SphereShape3D], are fast to check collisions against. [ConvexPolygonShape3D] and [HeightMapShape3D] are slower, and [ConcavePolygonShape3D] is the slowest.
##
## @tutorial(Physics introduction): https://docs.godotengine.org/en/stable/tutorials/physics/physics_introduction.html



## The shape's custom solver bias. Defines how much bodies react to enforce contact separation when this shape is involved.
## When set to [code]0[/code], the default value from [member ProjectSettings.physics/3d/solver/default_contact_bias] is used.
var custom_solver_bias: float:
	get = get_custom_solver_bias, set = set_custom_solver_bias

## The collision margin for the shape. This is not used in Godot Physics.
## Collision margins allow collision detection to be more efficient by adding an extra shell around shapes. Collision algorithms are more expensive when objects overlap by more than their margin, so a higher value for margins is better for performance, at the cost of accuracy around edges as it makes them less sharp.
var margin: float:
	get = get_margin, set = set_margin



## Returns the [ArrayMesh] used to draw the debug collision for this [Shape3D].
func get_debug_mesh() -> ArrayMesh:
	pass;


func get_custom_solver_bias() -> float:
	return custom_solver_bias

func set_custom_solver_bias(value: float) -> void:
	custom_solver_bias = value

func get_margin() -> float:
	return margin

func set_margin(value: float) -> void:
	margin = value

