extends Shape2D
class_name SeparationRayShape2D

## A 2D ray shape used for physics collision that tries to separate itself from any collider.
##
## A 2D ray shape, intended for use in physics. Usually used to provide a shape for a [CollisionShape2D]. When a [SeparationRayShape2D] collides with an object, it tries to separate itself from it by moving its endpoint to the collision point. For example, a [SeparationRayShape2D] next to a character can allow it to instantly move up when touching stairs.



## The ray's length.
var length: float:
	get = get_length, set = set_length

## If [code]false[/code] (default), the shape always separates and returns a normal along its own direction.
## If [code]true[/code], the shape can return the correct normal and separate in any direction, allowing sliding motion on slopes.
var slide_on_slope: bool:
	get = get_slide_on_slope, set = set_slide_on_slope




func get_length() -> float:
	return length

func set_length(value: float) -> void:
	length = value

func get_slide_on_slope() -> bool:
	return slide_on_slope

func set_slide_on_slope(value: bool) -> void:
	slide_on_slope = value

