extends RefCounted
class_name Semaphore

## A synchronization mechanism used to control access to a shared resource by [Thread]s.
##
## A synchronization semaphore that can be used to synchronize multiple [Thread]s. Initialized to zero on creation. For a binary version, see [Mutex].
## [b]Warning:[/b] Semaphores must be used carefully to avoid deadlocks.
## [b]Warning:[/b] To guarantee that the operating system is able to perform proper cleanup (no crashes, no deadlocks), these conditions must be met:
## - When a [Semaphore]'s reference count reaches zero and it is therefore destroyed, no threads must be waiting on it.
## - When a [Thread]'s reference count reaches zero and it is therefore destroyed, it must not be waiting on any semaphore.
##
## @tutorial(Using multiple threads): https://docs.godotengine.org/en/stable/tutorials/performance/using_multiple_threads.html
## @tutorial(Thread-safe APIs): https://docs.godotengine.org/en/stable/tutorials/performance/thread_safe_apis.html





## Lowers the [Semaphore], allowing one more thread in.
func post() -> void:
	pass;

## Like [method wait], but won't block, so if the value is zero, fails immediately and returns [code]false[/code]. If non-zero, it returns [code]true[/code] to report success.
func try_wait() -> bool:
	pass;

## Waits for the [Semaphore], if its value is zero, blocks until non-zero.
func wait() -> void:
	pass;


