extends ResourceImporter
class_name ResourceImporterBMFont

## Imports a bitmap font in the BMFont ([code].fnt[/code]) format.
##
## The BMFont format is a format created by the [url=https://www.angelcode.com/products/bmfont/]BMFont[/url] program. Many BMFont-compatible programs also exist, like [url=https://www.bmglyph.com/]BMGlyph[/url].
## Compared to [ResourceImporterImageFont], [ResourceImporterBMFont] supports bitmap fonts with varying glyph widths/heights.
## See also [ResourceImporterDynamicFont].
##
## @tutorial(Bitmap fonts - Using fonts): https://docs.godotengine.org/en/stable/tutorials/ui/gui_using_fonts.html#bitmap-fonts



## If [code]true[/code], uses lossless compression for the resulting font.
var compress: bool

## List of font fallbacks to use if a glyph isn't found in this bitmap font. Fonts at the beginning of the array are attempted first.
var fallbacks: Array

## Font scaling mode.
var scaling_mode: int




