extends RefCounted
class_name PackedDataContainerRef

## An internal class used by [PackedDataContainer] to pack nested arrays and dictionaries.
##
## When packing nested containers using [PackedDataContainer], they are recursively packed into [PackedDataContainerRef] (only applies to [Array] and [Dictionary]). Their data can be retrieved the same way as from [PackedDataContainer].
## [codeblock]
## var packed = PackedDataContainer.new()
## packed.pack([1, 2, 3, ["abc", "def"], 4, 5, 6])
## for element in packed:
## if element is PackedDataContainerRef:
## for subelement in element:
## print("::", subelement)
## else:
## print(element)
## # Prints:
## # 1
## # 2
## # 3
## # ::abc
## # ::def
## # 4
## # 5
## # 6
## [/codeblock]





## Returns the size of the packed container (see [method Array.size] and [method Dictionary.size]).
func size() -> int:
	pass;


