extends Node3D
class_name NavigationLink3D

## A link between two positions on [NavigationRegion3D]s that agents can be routed through.
##
## A link between two positions on [NavigationRegion3D]s that agents can be routed through. These positions can be on the same [NavigationRegion3D] or on two different ones. Links are useful to express navigation methods other than traveling along the surface of the navigation mesh, such as ziplines, teleporters, or gaps that can be jumped across.
##
## @tutorial(Using NavigationLinks): https://docs.godotengine.org/en/stable/tutorials/navigation/navigation_using_navigationlinks.html
## @experimental



## Whether this link can be traveled in both directions or only from [member start_position] to [member end_position].
var bidirectional: bool:
	get = is_bidirectional, set = set_bidirectional

## Whether this link is currently active. If [code]false[/code], [method NavigationServer3D.map_get_path] will ignore this link.
var enabled: bool:
	get = is_enabled, set = set_enabled

## Ending position of the link.
## This position will search out the nearest polygon in the navigation mesh to attach to.
## The distance the link will search is controlled by [method NavigationServer3D.map_set_link_connection_radius].
var end_position: Vector3:
	get = get_end_position, set = set_end_position

## When pathfinding enters this link from another regions navigation mesh the [member enter_cost] value is added to the path distance for determining the shortest path.
var enter_cost: float:
	get = get_enter_cost, set = set_enter_cost

## A bitfield determining all navigation layers the link belongs to. These navigation layers will be checked when requesting a path with [method NavigationServer3D.map_get_path].
var navigation_layers: int:
	get = get_navigation_layers, set = set_navigation_layers

## Starting position of the link.
## This position will search out the nearest polygon in the navigation mesh to attach to.
## The distance the link will search is controlled by [method NavigationServer3D.map_set_link_connection_radius].
var start_position: Vector3:
	get = get_start_position, set = set_start_position

## When pathfinding moves along the link the traveled distance is multiplied with [member travel_cost] for determining the shortest path.
var travel_cost: float:
	get = get_travel_cost, set = set_travel_cost



## Returns the [member end_position] that is relative to the link as a global position.
func get_global_end_position() -> Vector3:
	pass;

## Returns the [member start_position] that is relative to the link as a global position.
func get_global_start_position() -> Vector3:
	pass;

## Returns whether or not the specified layer of the [member navigation_layers] bitmask is enabled, given a [param layer_number] between 1 and 32.
func get_navigation_layer_value(layer_number: int) -> bool:
	pass;

## Sets the [member end_position] that is relative to the link from a global [param position].
func set_global_end_position(position: Vector3) -> void:
	pass;

## Sets the [member start_position] that is relative to the link from a global [param position].
func set_global_start_position(position: Vector3) -> void:
	pass;

## Based on [param value], enables or disables the specified layer in the [member navigation_layers] bitmask, given a [param layer_number] between 1 and 32.
func set_navigation_layer_value(layer_number: int, value: bool) -> void:
	pass;


func is_bidirectional() -> bool:
	return bidirectional

func set_bidirectional(value: bool) -> void:
	bidirectional = value

func is_enabled() -> bool:
	return enabled

func set_enabled(value: bool) -> void:
	enabled = value

func get_end_position() -> Vector3:
	return end_position

func set_end_position(value: Vector3) -> void:
	end_position = value

func get_enter_cost() -> float:
	return enter_cost

func set_enter_cost(value: float) -> void:
	enter_cost = value

func get_navigation_layers() -> int:
	return navigation_layers

func set_navigation_layers(value: int) -> void:
	navigation_layers = value

func get_start_position() -> Vector3:
	return start_position

func set_start_position(value: Vector3) -> void:
	start_position = value

func get_travel_cost() -> float:
	return travel_cost

func set_travel_cost(value: float) -> void:
	travel_cost = value

