extends Container
class_name GraphElement

## A container that represents a basic element that can be placed inside a [GraphEdit] control.
##
## [GraphElement] allows to create custom elements for a [GraphEdit] graph. By default such elements can be selected, resized, and repositioned, but they cannot be connected. For a graph element that allows for connections see [GraphNode].
## @experimental


## Emitted when removing the GraphElement is requested.
signal delete_request
## Emitted when the GraphElement is dragged.
signal dragged(from: Vector2, to: Vector2)
## Emitted when the GraphElement is deselected.
signal node_deselected
## Emitted when the GraphElement is selected.
signal node_selected
## Emitted when the GraphElement is moved.
signal position_offset_changed
## Emitted when displaying the GraphElement over other ones is requested. Happens on focusing (clicking into) the GraphElement.
signal raise_request
## Emitted when resizing the GraphElement is requested. Happens on dragging the resizer handle (see [member resizable]).
signal resize_request(new_minsize: Vector2)

## If [code]true[/code], the user can drag the GraphElement.
var draggable: bool:
	get = is_draggable, set = set_draggable

## The offset of the GraphElement, relative to the scroll offset of the [GraphEdit].
var position_offset: Vector2:
	get = get_position_offset, set = set_position_offset

## If [code]true[/code], the user can resize the GraphElement.
## [b]Note:[/b] Dragging the handle will only emit the [signal resize_request] signal, the GraphElement needs to be resized manually.
var resizable: bool:
	get = is_resizable, set = set_resizable

## If [code]true[/code], the user can select the GraphElement.
var selectable: bool:
	get = is_selectable, set = set_selectable

## If [code]true[/code], the GraphElement is selected.
var selected: bool:
	get = is_selected, set = set_selected




func is_draggable() -> bool:
	return draggable

func set_draggable(value: bool) -> void:
	draggable = value

func get_position_offset() -> Vector2:
	return position_offset

func set_position_offset(value: Vector2) -> void:
	position_offset = value

func is_resizable() -> bool:
	return resizable

func set_resizable(value: bool) -> void:
	resizable = value

func is_selectable() -> bool:
	return selectable

func set_selectable(value: bool) -> void:
	selectable = value

func is_selected() -> bool:
	return selected

func set_selected(value: bool) -> void:
	selected = value

