extends GPUParticlesCollision3D
class_name GPUParticlesCollisionBox3D

## A box-shaped 3D particle collision shape affecting [GPUParticles3D] nodes.
##
## A box-shaped 3D particle collision shape affecting [GPUParticles3D] nodes.
## Particle collision shapes work in real-time and can be moved, rotated and scaled during gameplay. Unlike attractors, non-uniform scaling of collision shapes is [i]not[/i] supported.
## [b]Note:[/b] [member ParticleProcessMaterial.collision_mode] must be [constant ParticleProcessMaterial.COLLISION_RIGID] or [constant ParticleProcessMaterial.COLLISION_HIDE_ON_CONTACT] on the [GPUParticles3D]'s process material for collision to work.
## [b]Note:[/b] Particle collision only affects [GPUParticles3D], not [CPUParticles3D].



## The collision box's size in 3D units.
var size: Vector3:
	get = get_size, set = set_size




func get_size() -> Vector3:
	return size

func set_size(value: Vector3) -> void:
	size = value

