extends Button
class_name CheckBox

## A button that represents a binary choice.
##
## [CheckBox] allows the user to choose one of only two possible options. It's similar to [CheckButton] in functionality, but it has a different appearance. To follow established UX patterns, it's recommended to use [CheckBox] when toggling it has [b]no[/b] immediate effect on something. For example, it could be used when toggling it will only do something once a confirmation button is pressed.
## See also [BaseButton] which contains common properties and methods associated with this node.
## When [member BaseButton.button_group] specifies a [ButtonGroup], [CheckBox] changes its appearance to that of a radio button and uses the various [code]radio_*[/code] theme properties.



var alignment: int:
	get = get_text_alignment, set = set_text_alignment

var toggle_mode: bool:
	get = is_toggle_mode, set = set_toggle_mode




func get_text_alignment() -> int:
	return alignment

func set_text_alignment(value: int) -> void:
	alignment = value

func is_toggle_mode() -> bool:
	return toggle_mode

func set_toggle_mode(value: bool) -> void:
	toggle_mode = value

