extends VisualInstance3D
class_name VisibleOnScreenNotifier3D

## A box-shaped region of 3D space that detects whether it is visible on screen.
##
## [VisibleOnScreenEnabler3D] represents a box-shaped region of 3D space. When any part of this region becomes visible on screen or in a [Camera3D]'s view, it will emit a [signal screen_entered] signal, and likewise it will emit a [signal screen_exited] signal when no part of it remains visible.
## If you want a node to be enabled automatically when this region is visible on screen, use [VisibleOnScreenEnabler3D].
## [b]Note:[/b] [VisibleOnScreenNotifier3D] uses an approximate heuristic that doesn't take walls and other occlusion into account, unless occlusion culling is used. It also won't function unless [member Node3D.visible] is set to [code]true[/code].


## Emitted when the [VisibleOnScreenNotifier3D] enters the screen.
signal screen_entered
## Emitted when the [VisibleOnScreenNotifier3D] exits the screen.
signal screen_exited

## The [VisibleOnScreenNotifier3D]'s bounding box.
var aabb: AABB:
	get = get_aabb, set = set_aabb



## Returns [code]true[/code] if the bounding box is on the screen.
## [b]Note:[/b] It takes one frame for the [VisibleOnScreenNotifier3D]'s visibility to be assessed once added to the scene tree, so this method will always return [code]false[/code] right after it is instantiated.
func is_on_screen() -> bool:
	pass;


func get_aabb() -> AABB:
	return aabb

func set_aabb(value: AABB) -> void:
	aabb = value

