class_name Vector4

## A 4D vector using floating point coordinates.
##
## A 4-element structure that can be used to represent 4D coordinates or any other quadruplet of numeric values.
## It uses floating-point coordinates. By default, these floating-point values use 32-bit precision, unlike [float] which is always 64-bit. If double precision is needed, compile the engine with the option [code]precision=double[/code].
## See [Vector4i] for its integer counterpart.
## [b]Note:[/b] In a boolean context, a Vector4 will evaluate to [code]false[/code] if it's equal to [code]Vector4(0, 0, 0, 0)[/code]. Otherwise, a Vector4 will always evaluate to [code]true[/code].


## Enumerated value for the X axis. Returned by [method max_axis_index] and [method min_axis_index].
const AXIS_X = 0;

## Enumerated value for the Y axis. Returned by [method max_axis_index] and [method min_axis_index].
const AXIS_Y = 1;

## Enumerated value for the Z axis. Returned by [method max_axis_index] and [method min_axis_index].
const AXIS_Z = 2;

## Enumerated value for the W axis. Returned by [method max_axis_index] and [method min_axis_index].
const AXIS_W = 3;

## Zero vector, a vector with all components set to [code]0[/code].
const ZERO = Vector4(0, 0, 0, 0);

## One vector, a vector with all components set to [code]1[/code].
const ONE = Vector4(1, 1, 1, 1);

## Infinity vector, a vector with all components set to [constant @GDScript.INF].
const INF = Vector4(inf, inf, inf, inf);


## The vector's W component. Also accessible by using the index position [code][3][/code].
var w: float

## The vector's X component. Also accessible by using the index position [code][0][/code].
var x: float

## The vector's Y component. Also accessible by using the index position [code][1][/code].
var y: float

## The vector's Z component. Also accessible by using the index position [code][2][/code].
var z: float


## Constructs a default-initialized [Vector4] with all components set to [code]0[/code].
func Vector4() -> Vector4:
	pass;

## Constructs a [Vector4] as a copy of the given [Vector4].
func Vector4(from: Vector4) -> Vector4:
	pass;

## Constructs a new [Vector4] from the given [Vector4i].
func Vector4(from: Vector4i) -> Vector4:
	pass;

## Returns a [Vector4] with the given components.
func Vector4(x: float, y: float, z: float, w: float) -> Vector4:
	pass;


## Returns a new vector with all components in absolute values (i.e. positive).
func abs() -> Vector4:
	pass;

## Returns a new vector with all components rounded up (towards positive infinity).
func ceil() -> Vector4:
	pass;

## Returns a new vector with all components clamped between the components of [param min] and [param max], by running [method @GlobalScope.clamp] on each component.
func clamp(min: Vector4, max: Vector4) -> Vector4:
	pass;

## Performs a cubic interpolation between this vector and [param b] using [param pre_a] and [param post_b] as handles, and returns the result at position [param weight]. [param weight] is on the range of 0.0 to 1.0, representing the amount of interpolation.
func cubic_interpolate(b: Vector4, pre_a: Vector4, post_b: Vector4, weight: float) -> Vector4:
	pass;

## Performs a cubic interpolation between this vector and [param b] using [param pre_a] and [param post_b] as handles, and returns the result at position [param weight]. [param weight] is on the range of 0.0 to 1.0, representing the amount of interpolation.
## It can perform smoother interpolation than [method cubic_interpolate] by the time values.
func cubic_interpolate_in_time(b: Vector4, pre_a: Vector4, post_b: Vector4, weight: float, b_t: float, pre_a_t: float, post_b_t: float) -> Vector4:
	pass;

## Returns the normalized vector pointing from this vector to [param to]. This is equivalent to using [code](b - a).normalized()[/code].
func direction_to(to: Vector4) -> Vector4:
	pass;

## Returns the squared distance between this vector and [param to].
## This method runs faster than [method distance_to], so prefer it if you need to compare vectors or need the squared distance for some formula.
func distance_squared_to(to: Vector4) -> float:
	pass;

## Returns the distance between this vector and [param to].
func distance_to(to: Vector4) -> float:
	pass;

## Returns the dot product of this vector and [param with].
func dot(with: Vector4) -> float:
	pass;

## Returns a new vector with all components rounded down (towards negative infinity).
func floor() -> Vector4:
	pass;

## Returns the inverse of the vector. This is the same as [code]Vector4(1.0 / v.x, 1.0 / v.y, 1.0 / v.z, 1.0 / v.w)[/code].
func inverse() -> Vector4:
	pass;

## Returns [code]true[/code] if this vector and [param to] are approximately equal, by running [method @GlobalScope.is_equal_approx] on each component.
func is_equal_approx(to: Vector4) -> bool:
	pass;

## Returns [code]true[/code] if this vector is finite, by calling [method @GlobalScope.is_finite] on each component.
func is_finite() -> bool:
	pass;

## Returns [code]true[/code] if the vector is normalized, i.e. its length is approximately equal to 1.
func is_normalized() -> bool:
	pass;

## Returns [code]true[/code] if this vector's values are approximately zero, by running [method @GlobalScope.is_zero_approx] on each component.
## This method is faster than using [method is_equal_approx] with one value as a zero vector.
func is_zero_approx() -> bool:
	pass;

## Returns the length (magnitude) of this vector.
func length() -> float:
	pass;

## Returns the squared length (squared magnitude) of this vector.
## This method runs faster than [method length], so prefer it if you need to compare vectors or need the squared distance for some formula.
func length_squared() -> float:
	pass;

## Returns the result of the linear interpolation between this vector and [param to] by amount [param weight]. [param weight] is on the range of [code]0.0[/code] to [code]1.0[/code], representing the amount of interpolation.
func lerp(to: Vector4, weight: float) -> Vector4:
	pass;

## Returns the axis of the vector's highest value. See [code]AXIS_*[/code] constants. If all components are equal, this method returns [constant AXIS_X].
func max_axis_index() -> int:
	pass;

## Returns the axis of the vector's lowest value. See [code]AXIS_*[/code] constants. If all components are equal, this method returns [constant AXIS_W].
func min_axis_index() -> int:
	pass;

## Returns the result of scaling the vector to unit length. Equivalent to [code]v / v.length()[/code]. See also [method is_normalized].
## [b]Note:[/b] This function may return incorrect values if the input vector length is near zero.
func normalized() -> Vector4:
	pass;

## Returns a vector composed of the [method @GlobalScope.fposmod] of this vector's components and [param mod].
func posmod(mod: float) -> Vector4:
	pass;

## Returns a vector composed of the [method @GlobalScope.fposmod] of this vector's components and [param modv]'s components.
func posmodv(modv: Vector4) -> Vector4:
	pass;

## Returns a new vector with all components rounded to the nearest integer, with halfway cases rounded away from zero.
func round() -> Vector4:
	pass;

## Returns a new vector with each component set to [code]1.0[/code] if it's positive, [code]-1.0[/code] if it's negative, and [code]0.0[/code] if it's zero. The result is identical to calling [method @GlobalScope.sign] on each component.
func sign() -> Vector4:
	pass;

## Returns a new vector with each component snapped to the nearest multiple of the corresponding component in [param step]. This can also be used to round the components to an arbitrary number of decimals.
func snapped(step: Vector4) -> Vector4:
	pass;


