extends Resource
class_name StyleBox

## Abstract base class for defining stylized boxes for UI elements.
##
## [StyleBox] is an abstract base class for drawing stylized boxes for UI elements. It is used for panels, buttons, [LineEdit] backgrounds, [Tree] backgrounds, etc. and also for testing a transparency mask for pointer signals. If mask test fails on a [StyleBox] assigned as mask to a control, clicks and motion signals will go through it to the one below.
## [b]Note:[/b] For control nodes that have [i]Theme Properties[/i], the [code]focus[/code] [StyleBox] is displayed over the [code]normal[/code], [code]hover[/code] or [code]pressed[/code] [StyleBox]. This makes the [code]focus[/code] [StyleBox] more reusable across different nodes.



## The bottom margin for the contents of this style box. Increasing this value reduces the space available to the contents from the bottom.
## If this value is negative, it is ignored and a child-specific margin is used instead. For example, for [StyleBoxFlat], the border thickness (if any) is used instead.
## It is up to the code using this style box to decide what these contents are: for example, a [Button] respects this content margin for the textual contents of the button.
## [method get_margin] should be used to fetch this value as consumer instead of reading these properties directly. This is because it correctly respects negative values and the fallback mentioned above.
var content_margin_bottom: float:
	get = get_content_margin, set = set_content_margin

## The left margin for the contents of this style box. Increasing this value reduces the space available to the contents from the left.
## Refer to [member content_margin_bottom] for extra considerations.
var content_margin_left: float:
	get = get_content_margin, set = set_content_margin

## The right margin for the contents of this style box. Increasing this value reduces the space available to the contents from the right.
## Refer to [member content_margin_bottom] for extra considerations.
var content_margin_right: float:
	get = get_content_margin, set = set_content_margin

## The top margin for the contents of this style box. Increasing this value reduces the space available to the contents from the top.
## Refer to [member content_margin_bottom] for extra considerations.
var content_margin_top: float:
	get = get_content_margin, set = set_content_margin



func _draw(to_canvas_item: RID, rect: Rect2) -> void:
	pass;

func _get_draw_rect(rect: Rect2) -> Rect2:
	pass;

## Virtual method to be implemented by the user. Returns a custom minimum size that the stylebox must respect when drawing. By default [method get_minimum_size] only takes content margins into account. This method can be overridden to add another size restriction. A combination of the default behavior and the output of this method will be used, to account for both sizes.
func _get_minimum_size() -> Vector2:
	pass;

func _test_mask(point: Vector2, rect: Rect2) -> bool:
	pass;

## Draws this stylebox using a canvas item identified by the given [RID].
## The [RID] value can either be the result of [method CanvasItem.get_canvas_item] called on an existing [CanvasItem]-derived node, or directly from creating a canvas item in the [RenderingServer] with [method RenderingServer.canvas_item_create].
func draw(canvas_item: RID, rect: Rect2) -> void:
	pass;

## Returns the default margin of the specified [enum Side].
func get_content_margin(margin: int) -> float:
	pass;

## Returns the [CanvasItem] that handles its [constant CanvasItem.NOTIFICATION_DRAW] or [method CanvasItem._draw] callback at this moment.
func get_current_item_drawn() -> CanvasItem:
	pass;

## Returns the content margin offset for the specified [enum Side].
## Positive values reduce size inwards, unlike [Control]'s margin values.
func get_margin(margin: int) -> float:
	pass;

## Returns the minimum size that this stylebox can be shrunk to.
func get_minimum_size() -> Vector2:
	pass;

## Returns the "offset" of a stylebox. This helper function returns a value equivalent to [code]Vector2(style.get_margin(MARGIN_LEFT), style.get_margin(MARGIN_TOP))[/code].
func get_offset() -> Vector2:
	pass;

## Sets the default value of the specified [enum Side] to [param offset] pixels.
func set_content_margin(margin: int, offset: float) -> void:
	pass;

## Sets the default margin to [param offset] pixels for all sides.
func set_content_margin_all(offset: float) -> void:
	pass;

## Test a position in a rectangle, return whether it passes the mask test.
func test_mask(point: Vector2, rect: Rect2) -> bool:
	pass;


func get_content_margin() -> float:
	return content_margin_bottom

func set_content_margin(value: float) -> void:
	content_margin_bottom = value

func get_content_margin() -> float:
	return content_margin_left

func set_content_margin(value: float) -> void:
	content_margin_left = value

func get_content_margin() -> float:
	return content_margin_right

func set_content_margin(value: float) -> void:
	content_margin_right = value

func get_content_margin() -> float:
	return content_margin_top

func set_content_margin(value: float) -> void:
	content_margin_top = value

