extends Node3D
class_name Skeleton3D

## A node containing a bone hierarchy, used to create a 3D skeletal animation.
##
## [Skeleton3D] provides an interface for managing a hierarchy of bones, including pose, rest and animation (see [Animation]). It can also use ragdoll physics.
## The overall transform of a bone with respect to the skeleton is determined by bone pose. Bone rest defines the initial transform of the bone pose.
## Note that "global pose" below refers to the overall transform of the bone with respect to skeleton, so it is not the actual global/world transform of the bone.
##
## @tutorial(3D Inverse Kinematics Demo): https://godotengine.org/asset-library/asset/523
## @tutorial(Third Person Shooter Demo): https://godotengine.org/asset-library/asset/678


## Emitted when the bone at [param bone_idx] is toggled with [method set_bone_enabled]. Use [method is_bone_enabled] to check the new value.
signal bone_enabled_changed(bone_idx: int)
## This signal is emitted when one of the bones in the Skeleton3D node have changed their pose. This is used to inform nodes that rely on bone positions that one of the bones in the Skeleton3D have changed their transform/pose.
signal bone_pose_changed(bone_idx: int)
## Emitted when the pose is updated, after [constant NOTIFICATION_UPDATE_SKELETON] is received.
signal pose_updated
## Emitted when the value of [member show_rest_only] changes.
signal show_rest_only_changed
## Notification received when this skeleton's pose needs to be updated.
## This notification is received [i]before[/i] the related [signal pose_updated] signal.
const NOTIFICATION_UPDATE_SKELETON = 50;


var animate_physical_bones: bool:
	get = get_animate_physical_bones, set = set_animate_physical_bones

## Multiplies the 3D position track animation.
## [b]Note:[/b] Unless this value is [code]1.0[/code], the key value in animation will not match the actual position value.
var motion_scale: float:
	get = get_motion_scale, set = set_motion_scale

## If [code]true[/code], forces the bones in their default rest pose, regardless of their values. In the editor, this also prevents the bones from being edited.
var show_rest_only: bool:
	get = is_show_rest_only, set = set_show_rest_only



## Adds a bone, with name [param name]. [method get_bone_count] will become the bone index.
func add_bone(name: String) -> void:
	pass;

## Clear all the bones in this skeleton.
func clear_bones() -> void:
	pass;

## Removes the global pose override on all bones in the skeleton.
func clear_bones_global_pose_override() -> void:
	pass;

func create_skin_from_rest_transforms() -> Skin:
	pass;

## Returns the bone index that matches [param name] as its name.
func find_bone(name: String) -> int:
	pass;

## Force updates the bone transforms/poses for all bones in the skeleton.
## [i]Deprecated.[/i] Do not use.
## @deprecated
func force_update_all_bone_transforms() -> void:
	pass;

## Force updates the bone transform for the bone at [param bone_idx] and all of its children.
func force_update_bone_child_transform(bone_idx: int) -> void:
	pass;

## Returns an array containing the bone indexes of all the child node of the passed in bone, [param bone_idx].
func get_bone_children(bone_idx: int) -> PackedInt32Array:
	pass;

## Returns the number of bones in the skeleton.
func get_bone_count() -> int:
	pass;

## Returns the overall transform of the specified bone, with respect to the skeleton. Being relative to the skeleton frame, this is not the actual "global" transform of the bone.
func get_bone_global_pose(bone_idx: int) -> Transform3D:
	pass;

## Returns the overall transform of the specified bone, with respect to the skeleton, but without any global pose overrides. Being relative to the skeleton frame, this is not the actual "global" transform of the bone.
func get_bone_global_pose_no_override(bone_idx: int) -> Transform3D:
	pass;

## Returns the global pose override transform for [param bone_idx].
func get_bone_global_pose_override(bone_idx: int) -> Transform3D:
	pass;

## Returns the global rest transform for [param bone_idx].
func get_bone_global_rest(bone_idx: int) -> Transform3D:
	pass;

## Returns the name of the bone at index [param bone_idx].
func get_bone_name(bone_idx: int) -> String:
	pass;

## Returns the bone index which is the parent of the bone at [param bone_idx]. If -1, then bone has no parent.
## [b]Note:[/b] The parent bone returned will always be less than [param bone_idx].
func get_bone_parent(bone_idx: int) -> int:
	pass;

## Returns the pose transform of the specified bone.
func get_bone_pose(bone_idx: int) -> Transform3D:
	pass;

## Returns the pose position of the bone at [param bone_idx]. The returned [Vector3] is in the local coordinate space of the [Skeleton3D] node.
func get_bone_pose_position(bone_idx: int) -> Vector3:
	pass;

## Returns the pose rotation of the bone at [param bone_idx]. The returned [Quaternion] is local to the bone with respect to the rotation of any parent bones.
func get_bone_pose_rotation(bone_idx: int) -> Quaternion:
	pass;

## Returns the pose scale of the bone at [param bone_idx].
func get_bone_pose_scale(bone_idx: int) -> Vector3:
	pass;

## Returns the rest transform for a bone [param bone_idx].
func get_bone_rest(bone_idx: int) -> Transform3D:
	pass;

## Returns an array with all of the bones that are parentless. Another way to look at this is that it returns the indexes of all the bones that are not dependent or modified by other bones in the Skeleton.
func get_parentless_bones() -> PackedInt32Array:
	pass;

## Returns the number of times the bone hierarchy has changed within this skeleton, including renames.
## The Skeleton version is not serialized: only use within a single instance of Skeleton3D.
## Use for invalidating caches in IK solvers and other nodes which process bones.
func get_version() -> int:
	pass;

## Returns whether the bone pose for the bone at [param bone_idx] is enabled.
func is_bone_enabled(bone_idx: int) -> bool:
	pass;

## Returns all bones in the skeleton to their rest poses.
func localize_rests() -> void:
	pass;

## Adds a collision exception to the physical bone.
## Works just like the [RigidBody3D] node.
func physical_bones_add_collision_exception(exception: RID) -> void:
	pass;

## Removes a collision exception to the physical bone.
## Works just like the [RigidBody3D] node.
func physical_bones_remove_collision_exception(exception: RID) -> void:
	pass;

## Tells the [PhysicalBone3D] nodes in the Skeleton to start simulating and reacting to the physics world.
## Optionally, a list of bone names can be passed-in, allowing only the passed-in bones to be simulated.
func physical_bones_start_simulation(bones: Array[StringName] = []) -> void:
	pass;

## Tells the [PhysicalBone3D] nodes in the Skeleton to stop simulating.
func physical_bones_stop_simulation() -> void:
	pass;

## Binds the given Skin to the Skeleton.
func register_skin(skin: Skin) -> SkinReference:
	pass;

## Sets the bone pose to rest for [param bone_idx].
func reset_bone_pose(bone_idx: int) -> void:
	pass;

## Sets all bone poses to rests.
func reset_bone_poses() -> void:
	pass;

## Disables the pose for the bone at [param bone_idx] if [code]false[/code], enables the bone pose if [code]true[/code].
func set_bone_enabled(bone_idx: int, enabled: bool = true) -> void:
	pass;

## Sets the global pose transform, [param pose], for the bone at [param bone_idx].
## [param amount] is the interpolation strength that will be used when applying the pose, and [param persistent] determines if the applied pose will remain.
## [b]Note:[/b] The pose transform needs to be a global pose! To convert a world transform from a [Node3D] to a global bone pose, multiply the [method Transform3D.affine_inverse] of the node's [member Node3D.global_transform] by the desired world transform.
func set_bone_global_pose_override(bone_idx: int, pose: Transform3D, amount: float, persistent: bool = false) -> void:
	pass;

func set_bone_name(bone_idx: int, name: String) -> void:
	pass;

## Sets the bone index [param parent_idx] as the parent of the bone at [param bone_idx]. If -1, then bone has no parent.
## [b]Note:[/b] [param parent_idx] must be less than [param bone_idx].
func set_bone_parent(bone_idx: int, parent_idx: int) -> void:
	pass;

## Sets the pose position of the bone at [param bone_idx] to [param position]. [param position] is a [Vector3] describing a position local to the [Skeleton3D] node.
func set_bone_pose_position(bone_idx: int, position: Vector3) -> void:
	pass;

## Sets the pose rotation of the bone at [param bone_idx] to [param rotation]. [param rotation] is a [Quaternion] describing a rotation in the bone's local coordinate space with respect to the rotation of any parent bones.
func set_bone_pose_rotation(bone_idx: int, rotation: Quaternion) -> void:
	pass;

## Sets the pose scale of the bone at [param bone_idx] to [param scale].
func set_bone_pose_scale(bone_idx: int, scale: Vector3) -> void:
	pass;

## Sets the rest transform for bone [param bone_idx].
func set_bone_rest(bone_idx: int, rest: Transform3D) -> void:
	pass;

## Unparents the bone at [param bone_idx] and sets its rest position to that of its parent prior to being reset.
func unparent_bone_and_rest(bone_idx: int) -> void:
	pass;


func get_animate_physical_bones() -> bool:
	return animate_physical_bones

func set_animate_physical_bones(value: bool) -> void:
	animate_physical_bones = value

func get_motion_scale() -> float:
	return motion_scale

func set_motion_scale(value: float) -> void:
	motion_scale = value

func is_show_rest_only() -> bool:
	return show_rest_only

func set_show_rest_only(value: bool) -> void:
	show_rest_only = value

