extends Node2D
class_name ShapeCast2D

## A 2D shape that sweeps a region of space to detect [CollisionObject2D]s.
##
## Shape casting allows to detect collision objects by sweeping its [member shape] along the cast direction determined by [member target_position]. This is similar to [RayCast2D], but it allows for sweeping a region of space, rather than just a straight line. [ShapeCast2D] can detect multiple collision objects. It is useful for things like wide laser beams or snapping a simple shape to a floor.
## Immediate collision overlaps can be done with the [member target_position] set to [code]Vector2(0, 0)[/code] and by calling [method force_shapecast_update] within the same physics frame. This helps to overcome some limitations of [Area2D] when used as an instantaneous detection area, as collision information isn't immediately available to it.
## [b]Note:[/b] Shape casting is more computationally expensive than ray casting.



## If [code]true[/code], collisions with [Area2D]s will be reported.
var collide_with_areas: bool:
	get = is_collide_with_areas_enabled, set = set_collide_with_areas

## If [code]true[/code], collisions with [PhysicsBody2D]s will be reported.
var collide_with_bodies: bool:
	get = is_collide_with_bodies_enabled, set = set_collide_with_bodies

## The shape's collision mask. Only objects in at least one collision layer enabled in the mask will be detected.
var collision_mask: int:
	get = get_collision_mask, set = set_collision_mask

## Returns the complete collision information from the collision sweep. The data returned is the same as in the [method PhysicsDirectSpaceState2D.get_rest_info] method.
var collision_result: Array:
	get = _get_collision_result

## If [code]true[/code], collisions will be reported.
var enabled: bool:
	get = is_enabled, set = set_enabled

## If [code]true[/code], the parent node will be excluded from collision detection.
var exclude_parent: bool:
	get = get_exclude_parent_body, set = set_exclude_parent_body

## The collision margin for the shape. A larger margin helps detecting collisions more consistently, at the cost of precision.
var margin: float:
	get = get_margin, set = set_margin

## The number of intersections can be limited with this parameter, to reduce the processing time.
var max_results: int:
	get = get_max_results, set = set_max_results

## The [Shape2D]-derived shape to be used for collision queries.
var shape: Shape2D:
	get = get_shape, set = set_shape

## The shape's destination point, relative to this node's [code]position[/code].
var target_position: Vector2:
	get = get_target_position, set = set_target_position



## Adds a collision exception so the shape does not report collisions with the specified [CollisionObject2D] node.
func add_exception(node: CollisionObject2D) -> void:
	pass;

## Adds a collision exception so the shape does not report collisions with the specified [RID].
func add_exception_rid(rid: RID) -> void:
	pass;

## Removes all collision exceptions for this shape.
func clear_exceptions() -> void:
	pass;

## Updates the collision information for the shape immediately, without waiting for the next [code]_physics_process[/code] call. Use this method, for example, when the shape or its parent has changed state.
## [b]Note:[/b] [code]enabled == true[/code] is not required for this to work.
func force_shapecast_update() -> void:
	pass;

## The fraction from the [ShapeCast2D]'s origin to its [member target_position] (between 0 and 1) of how far the shape can move without triggering a collision.
func get_closest_collision_safe_fraction() -> float:
	pass;

## The fraction from the [ShapeCast2D]'s origin to its [member target_position] (between 0 and 1) of how far the shape must move to trigger a collision.
func get_closest_collision_unsafe_fraction() -> float:
	pass;

## Returns the collided [Object] of one of the multiple collisions at [param index], or [code]null[/code] if no object is intersecting the shape (i.e. [method is_colliding] returns [code]false[/code]).
func get_collider(index: int) -> Object:
	pass;

## Returns the [RID] of the collided object of one of the multiple collisions at [param index].
func get_collider_rid(index: int) -> RID:
	pass;

## Returns the shape ID of the colliding shape of one of the multiple collisions at [param index], or [code]0[/code] if no object is intersecting the shape (i.e. [method is_colliding] returns [code]false[/code]).
func get_collider_shape(index: int) -> int:
	pass;

## The number of collisions detected at the point of impact. Use this to iterate over multiple collisions as provided by [method get_collider], [method get_collider_shape], [method get_collision_point], and [method get_collision_normal] methods.
func get_collision_count() -> int:
	pass;

## Returns whether or not the specified layer of the [member collision_mask] is enabled, given a [param layer_number] between 1 and 32.
func get_collision_mask_value(layer_number: int) -> bool:
	pass;

## Returns the normal of one of the multiple collisions at [param index] of the intersecting object.
func get_collision_normal(index: int) -> Vector2:
	pass;

## Returns the collision point of one of the multiple collisions at [param index] where the shape intersects the colliding object.
## [b]Note:[/b] this point is in the [b]global[/b] coordinate system.
func get_collision_point(index: int) -> Vector2:
	pass;

## Returns whether any object is intersecting with the shape's vector (considering the vector length).
func is_colliding() -> bool:
	pass;

## Removes a collision exception so the shape does report collisions with the specified [CollisionObject2D] node.
func remove_exception(node: CollisionObject2D) -> void:
	pass;

## Removes a collision exception so the shape does report collisions with the specified [RID].
func remove_exception_rid(rid: RID) -> void:
	pass;

## Based on [param value], enables or disables the specified layer in the [member collision_mask], given a [param layer_number] between 1 and 32.
func set_collision_mask_value(layer_number: int, value: bool) -> void:
	pass;


func is_collide_with_areas_enabled() -> bool:
	return collide_with_areas

func set_collide_with_areas(value: bool) -> void:
	collide_with_areas = value

func is_collide_with_bodies_enabled() -> bool:
	return collide_with_bodies

func set_collide_with_bodies(value: bool) -> void:
	collide_with_bodies = value

func get_collision_mask() -> int:
	return collision_mask

func set_collision_mask(value: int) -> void:
	collision_mask = value

func _get_collision_result() -> Array:
	return collision_result

func is_enabled() -> bool:
	return enabled

func set_enabled(value: bool) -> void:
	enabled = value

func get_exclude_parent_body() -> bool:
	return exclude_parent

func set_exclude_parent_body(value: bool) -> void:
	exclude_parent = value

func get_margin() -> float:
	return margin

func set_margin(value: float) -> void:
	margin = value

func get_max_results() -> int:
	return max_results

func set_max_results(value: int) -> void:
	max_results = value

func get_shape() -> Shape2D:
	return shape

func set_shape(value: Shape2D) -> void:
	shape = value

func get_target_position() -> Vector2:
	return target_position

func set_target_position(value: Vector2) -> void:
	target_position = value

