extends ResourceImporter
class_name ResourceImporterBitMap

## Imports a [BitMap] resource (2D array of boolean values).
##
## [BitMap] resources are typically used as click masks in [TextureButton] and [TouchScreenButton].
##
## @tutorial(Importing images): https://docs.godotengine.org/en/stable/tutorials/assets_pipeline/importing_images.html



## The data source to use for generating the bitmap.
## [b]Black & White:[/b] Pixels whose HSV value is greater than the [member threshold] will be considered as "enabled" (bit is [code]true[/code]). If the pixel is lower than or equal to the threshold, it will be considered as "disabled" (bit is [code]false[/code]).
## [b]Alpha:[/b] Pixels whose alpha value is greater than the [member threshold] will be considered as "enabled" (bit is [code]true[/code]). If the pixel is lower than or equal to the threshold, it will be considered as "disabled" (bit is [code]false[/code]).
var create_from: int

## The threshold to use to determine which bits should be considered enabled or disabled. See also [member create_from].
var threshold: float




