extends Node2D
class_name RayCast2D

## A ray in 2D space, used to find the first [CollisionObject2D] it intersects.
##
## A raycast represents a ray from its origin to its [member target_position] that finds the closest [CollisionObject2D] along its path, if it intersects any. This is useful for a lot of things, such as
## [RayCast2D] can ignore some objects by adding them to an exception list, by making its detection reporting ignore [Area2D]s ([member collide_with_areas]) or [PhysicsBody2D]s ([member collide_with_bodies]), or by configuring physics layers.
## [RayCast2D] calculates intersection every physics frame, and it holds the result until the next physics frame. For an immediate raycast, or if you want to configure a [RayCast2D] multiple times within the same physics frame, use [method force_raycast_update].
## To sweep over a region of 2D space, you can approximate the region with multiple [RayCast2D]s or use [ShapeCast2D].
##
## @tutorial(Ray-casting): https://docs.godotengine.org/en/stable/tutorials/physics/ray-casting.html



## If [code]true[/code], collisions with [Area2D]s will be reported.
var collide_with_areas: bool:
	get = is_collide_with_areas_enabled, set = set_collide_with_areas

## If [code]true[/code], collisions with [PhysicsBody2D]s will be reported.
var collide_with_bodies: bool:
	get = is_collide_with_bodies_enabled, set = set_collide_with_bodies

## The ray's collision mask. Only objects in at least one collision layer enabled in the mask will be detected. See [url=$DOCS_URL/tutorials/physics/physics_introduction.html#collision-layers-and-masks]Collision layers and masks[/url] in the documentation for more information.
var collision_mask: int:
	get = get_collision_mask, set = set_collision_mask

## If [code]true[/code], collisions will be reported.
var enabled: bool:
	get = is_enabled, set = set_enabled

## If [code]true[/code], the parent node will be excluded from collision detection.
var exclude_parent: bool:
	get = get_exclude_parent_body, set = set_exclude_parent_body

## If [code]true[/code], the ray will detect a hit when starting inside shapes. In this case the collision normal will be [code]Vector2(0, 0)[/code]. Does not affect concave polygon shapes.
var hit_from_inside: bool:
	get = is_hit_from_inside_enabled, set = set_hit_from_inside

## The ray's destination point, relative to the RayCast's [code]position[/code].
var target_position: Vector2:
	get = get_target_position, set = set_target_position



## Adds a collision exception so the ray does not report collisions with the specified [CollisionObject2D] node.
func add_exception(node: CollisionObject2D) -> void:
	pass;

## Adds a collision exception so the ray does not report collisions with the specified [RID].
func add_exception_rid(rid: RID) -> void:
	pass;

## Removes all collision exceptions for this ray.
func clear_exceptions() -> void:
	pass;

## Updates the collision information for the ray immediately, without waiting for the next [code]_physics_process[/code] call. Use this method, for example, when the ray or its parent has changed state.
## [b]Note:[/b] [member enabled] does not need to be [code]true[/code] for this to work.
func force_raycast_update() -> void:
	pass;

## Returns the first object that the ray intersects, or [code]null[/code] if no object is intersecting the ray (i.e. [method is_colliding] returns [code]false[/code]).
func get_collider() -> Object:
	pass;

## Returns the [RID] of the first object that the ray intersects, or an empty [RID] if no object is intersecting the ray (i.e. [method is_colliding] returns [code]false[/code]).
func get_collider_rid() -> RID:
	pass;

## Returns the shape ID of the first object that the ray intersects, or [code]0[/code] if no object is intersecting the ray (i.e. [method is_colliding] returns [code]false[/code]).
## To get the intersected shape node, for a [CollisionObject2D] target, use:
## [codeblocks]
## [gdscript]
## var target = get_collider() # A CollisionObject2D.
## var shape_id = get_collider_shape() # The shape index in the collider.
## var owner_id = target.shape_find_owner(shape_id) # The owner ID in the collider.
## var shape = target.shape_owner_get_owner(owner_id)
## [/gdscript]
## [csharp]
## var target = (CollisionObject2D)GetCollider(); // A CollisionObject2D.
## var shapeId = GetColliderShape(); // The shape index in the collider.
## var ownerId = target.ShapeFindOwner(shapeId); // The owner ID in the collider.
## var shape = target.ShapeOwnerGetOwner(ownerId);
## [/csharp]
## [/codeblocks]
func get_collider_shape() -> int:
	pass;

## Returns whether or not the specified layer of the [member collision_mask] is enabled, given a [param layer_number] between 1 and 32.
func get_collision_mask_value(layer_number: int) -> bool:
	pass;

## Returns the normal of the intersecting object's shape at the collision point, or [code]Vector2(0, 0)[/code] if the ray starts inside the shape and [member hit_from_inside] is [code]true[/code].
func get_collision_normal() -> Vector2:
	pass;

## Returns the collision point at which the ray intersects the closest object. If [member hit_from_inside] is [code]true[/code] and the ray starts inside of a collision shape, this function will return the origin point of the ray.
## [b]Note:[/b] This point is in the [b]global[/b] coordinate system.
func get_collision_point() -> Vector2:
	pass;

## Returns whether any object is intersecting with the ray's vector (considering the vector length).
func is_colliding() -> bool:
	pass;

## Removes a collision exception so the ray does report collisions with the specified [CollisionObject2D] node.
func remove_exception(node: CollisionObject2D) -> void:
	pass;

## Removes a collision exception so the ray does report collisions with the specified [RID].
func remove_exception_rid(rid: RID) -> void:
	pass;

## Based on [param value], enables or disables the specified layer in the [member collision_mask], given a [param layer_number] between 1 and 32.
func set_collision_mask_value(layer_number: int, value: bool) -> void:
	pass;


func is_collide_with_areas_enabled() -> bool:
	return collide_with_areas

func set_collide_with_areas(value: bool) -> void:
	collide_with_areas = value

func is_collide_with_bodies_enabled() -> bool:
	return collide_with_bodies

func set_collide_with_bodies(value: bool) -> void:
	collide_with_bodies = value

func get_collision_mask() -> int:
	return collision_mask

func set_collision_mask(value: int) -> void:
	collision_mask = value

func is_enabled() -> bool:
	return enabled

func set_enabled(value: bool) -> void:
	enabled = value

func get_exclude_parent_body() -> bool:
	return exclude_parent

func set_exclude_parent_body(value: bool) -> void:
	exclude_parent = value

func is_hit_from_inside_enabled() -> bool:
	return hit_from_inside

func set_hit_from_inside(value: bool) -> void:
	hit_from_inside = value

func get_target_position() -> Vector2:
	return target_position

func set_target_position(value: Vector2) -> void:
	target_position = value

