extends RefCounted
class_name RandomNumberGenerator

## Provides methods for generating pseudo-random numbers.
##
## RandomNumberGenerator is a class for generating pseudo-random numbers. It currently uses [url=https://www.pcg-random.org/]PCG32[/url].
## [b]Note:[/b] The underlying algorithm is an implementation detail and should not be depended upon.
## To generate a random float number (within a given range) based on a time-dependent seed:
## [codeblock]
## var rng = RandomNumberGenerator.new()
## func _ready():
## var my_random_number = rng.randf_range(-10.0, 10.0)
## [/codeblock]
##
## @tutorial(Random number generation): https://docs.godotengine.org/en/stable/tutorials/math/random_number_generation.html



## Initializes the random number generator state based on the given seed value. A given seed will give a reproducible sequence of pseudo-random numbers.
## [b]Note:[/b] The RNG does not have an avalanche effect, and can output similar random streams given similar seeds. Consider using a hash function to improve your seed quality if they're sourced externally.
## [b]Note:[/b] Setting this property produces a side effect of changing the internal [member state], so make sure to initialize the seed [i]before[/i] modifying the [member state]:
## [b]Note:[/b] The default value of this property is pseudo-random, and changes when calling [method randomize]. The [code]0[/code] value documented here is a placeholder, and not the actual default seed.
## [codeblock]
## var rng = RandomNumberGenerator.new()
## rng.seed = hash("Godot")
## rng.state = 100 # Restore to some previously saved state.
## [/codeblock]
var seed: int:
	get = get_seed, set = set_seed

## The current state of the random number generator. Save and restore this property to restore the generator to a previous state:
## [codeblock]
## var rng = RandomNumberGenerator.new()
## print(rng.randf())
## var saved_state = rng.state # Store current state.
## print(rng.randf()) # Advance internal state.
## rng.state = saved_state # Restore the state.
## print(rng.randf()) # Prints the same value as in previous.
## [/codeblock]
## [b]Note:[/b] Do not set state to arbitrary values, since the random number generator requires the state to have certain qualities to behave properly. It should only be set to values that came from the state property itself. To initialize the random number generator with arbitrary input, use [member seed] instead.
## [b]Note:[/b] The default value of this property is pseudo-random, and changes when calling [method randomize]. The [code]0[/code] value documented here is a placeholder, and not the actual default seed.
var state: int:
	get = get_state, set = set_state



## Returns a pseudo-random float between [code]0.0[/code] and [code]1.0[/code] (inclusive).
func randf() -> float:
	pass;

## Returns a pseudo-random float between [param from] and [param to] (inclusive).
func randf_range(from: float, to: float) -> float:
	pass;

## Returns a [url=https://en.wikipedia.org/wiki/Normal_distribution]normally-distributed[/url] pseudo-random number, using Box-Muller transform with the specified [param mean] and a standard [param deviation]. This is also called Gaussian distribution.
func randfn(mean: float = 0.0, deviation: float = 1.0) -> float:
	pass;

## Returns a pseudo-random 32-bit unsigned integer between [code]0[/code] and [code]4294967295[/code] (inclusive).
func randi() -> int:
	pass;

## Returns a pseudo-random 32-bit signed integer between [param from] and [param to] (inclusive).
func randi_range(from: int, to: int) -> int:
	pass;

## Sets up a time-based seed for this [RandomNumberGenerator] instance. Unlike the [@GlobalScope] random number generation functions, different [RandomNumberGenerator] instances can use different seeds.
func randomize() -> void:
	pass;


func get_seed() -> int:
	return seed

func set_seed(value: int) -> void:
	seed = value

func get_state() -> int:
	return state

func set_state(value: int) -> void:
	state = value

