extends Node2D
class_name NavigationRegion2D

## A traversable 2D region that [NavigationAgent2D]s can use for pathfinding.
##
## A traversable 2D region based on a [NavigationPolygon] that [NavigationAgent2D]s can use for pathfinding.
## Two regions can be connected to each other if they share a similar edge. You can set the minimum distance between two vertices required to connect two edges by using [method NavigationServer2D.map_set_edge_connection_margin].
## [b]Note:[/b] Overlapping two regions' navigation polygons is not enough for connecting two regions. They must share a similar edge.
## The pathfinding cost of entering a region from another region can be controlled with the [member enter_cost] value.
## [b]Note:[/b] This value is not added to the path cost when the start position is already inside this region.
## The pathfinding cost of traveling distances inside this region can be controlled with the [member travel_cost] multiplier.
## [b]Note:[/b] This node caches changes to its properties, so if you make changes to the underlying region [RID] in [NavigationServer2D], they will not be reflected in this node's properties.
##
## @tutorial(Using NavigationRegions): https://docs.godotengine.org/en/stable/tutorials/navigation/navigation_using_navigationregions.html
## @experimental


## Emitted when a navigation polygon bake operation is completed.
signal bake_finished
## Emitted when the used navigation polygon is replaced or changes to the internals of the current navigation polygon are committed.
signal navigation_polygon_changed

## A bitfield determining all avoidance layers for the avoidance constrain.
var avoidance_layers: int:
	get = get_avoidance_layers, set = set_avoidance_layers

## If [code]true[/code] constraints avoidance agent's with an avoidance mask bit that matches with a bit of the [member avoidance_layers] to the navigation polygon. Due to each navigation polygon outline creating an obstacle and each polygon edge creating an avoidance line constrain keep the navigation polygon shape as simple as possible for performance.
## [b]Experimental:[/b] This is an experimental feature and should not be used in production as agent's can get stuck on the navigation polygon corners and edges especially at high frame rate.
var constrain_avoidance: bool:
	get = get_constrain_avoidance, set = set_constrain_avoidance

## Determines if the [NavigationRegion2D] is enabled or disabled.
var enabled: bool:
	get = is_enabled, set = set_enabled

## When pathfinding enters this region's navigation mesh from another regions navigation mesh the [member enter_cost] value is added to the path distance for determining the shortest path.
var enter_cost: float:
	get = get_enter_cost, set = set_enter_cost

## A bitfield determining all navigation layers the region belongs to. These navigation layers can be checked upon when requesting a path with [method NavigationServer2D.map_get_path].
var navigation_layers: int:
	get = get_navigation_layers, set = set_navigation_layers

## The [NavigationPolygon] resource to use.
var navigation_polygon: NavigationPolygon:
	get = get_navigation_polygon, set = set_navigation_polygon

## When pathfinding moves inside this region's navigation mesh the traveled distances are multiplied with [member travel_cost] for determining the shortest path.
var travel_cost: float:
	get = get_travel_cost, set = set_travel_cost

## If enabled the navigation region will use edge connections to connect with other navigation regions within proximity of the navigation map edge connection margin.
var use_edge_connections: bool:
	get = get_use_edge_connections, set = set_use_edge_connections



## Bakes the [NavigationPolygon]. If [param on_thread] is set to [code]true[/code] (default), the baking is done on a separate thread.
func bake_navigation_polygon(on_thread: bool = true) -> void:
	pass;

## Returns whether or not the specified layer of the [member avoidance_layers] bitmask is enabled, given a [param layer_number] between 1 and 32.
func get_avoidance_layer_value(layer_number: int) -> bool:
	pass;

## Returns whether or not the specified layer of the [member navigation_layers] bitmask is enabled, given a [param layer_number] between 1 and 32.
func get_navigation_layer_value(layer_number: int) -> bool:
	pass;

## Returns the current navigation map [RID] used by this region.
func get_navigation_map() -> RID:
	pass;

## Returns the [RID] of this region on the [NavigationServer2D].
## [i]Deprecated.[/i] Use [method get_rid] instead.
## @deprecated
func get_region_rid() -> RID:
	pass;

## Returns the [RID] of this region on the [NavigationServer2D]. Combined with [method NavigationServer2D.map_get_closest_point_owner] can be used to identify the [NavigationRegion2D] closest to a point on the merged navigation map.
func get_rid() -> RID:
	pass;

## Based on [param value], enables or disables the specified layer in the [member avoidance_layers] bitmask, given a [param layer_number] between 1 and 32.
func set_avoidance_layer_value(layer_number: int, value: bool) -> void:
	pass;

## Based on [param value], enables or disables the specified layer in the [member navigation_layers] bitmask, given a [param layer_number] between 1 and 32.
func set_navigation_layer_value(layer_number: int, value: bool) -> void:
	pass;

## Sets the [RID] of the navigation map this region should use. By default the region will automatically join the [World2D] default navigation map so this function is only required to override the default map.
func set_navigation_map(navigation_map: RID) -> void:
	pass;


func get_avoidance_layers() -> int:
	return avoidance_layers

func set_avoidance_layers(value: int) -> void:
	avoidance_layers = value

func get_constrain_avoidance() -> bool:
	return constrain_avoidance

func set_constrain_avoidance(value: bool) -> void:
	constrain_avoidance = value

func is_enabled() -> bool:
	return enabled

func set_enabled(value: bool) -> void:
	enabled = value

func get_enter_cost() -> float:
	return enter_cost

func set_enter_cost(value: float) -> void:
	enter_cost = value

func get_navigation_layers() -> int:
	return navigation_layers

func set_navigation_layers(value: int) -> void:
	navigation_layers = value

func get_navigation_polygon() -> NavigationPolygon:
	return navigation_polygon

func set_navigation_polygon(value: NavigationPolygon) -> void:
	navigation_polygon = value

func get_travel_cost() -> float:
	return travel_cost

func set_travel_cost(value: float) -> void:
	travel_cost = value

func get_use_edge_connections() -> bool:
	return use_edge_connections

func set_use_edge_connections(value: bool) -> void:
	use_edge_connections = value

